package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemHelpQuery;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemHelpVO;
import com.elitesland.tw.tw5.api.prd.work.query.PrdWorkAssignmentQuery;
import com.elitesland.tw.tw5.api.prd.work.vo.PrdWorkAssignmentVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemHelpDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemHelpDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdSystemHelpRepo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.List;

@Repository
@RequiredArgsConstructor
public class PrdSystemHelpDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdSystemHelpRepo repo;
    private final QPrdSystemHelpDO qdo = QPrdSystemHelpDO.prdSystemHelpDO;

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PrdSystemHelpDO save(PrdSystemHelpDO ado) {
        return repo.save(ado);
    }

    /**
     * 逻辑删除
     *
     * @param key 主键
     * @return 删除的行数
     */
    public long deleteSoft(Long key) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.eq(key));
        return update.execute();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PrdSystemHelpVO> queryPaging(PrdSystemHelpQuery query) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = getJpaQueryWhere(query);
        QueryResults<PrdSystemHelpVO> result = jpaQuery.offset(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).fetchResults();
        return PagingVO.<PrdSystemHelpVO>builder().records(result.getResults()).total(result.getTotal()).build();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PrdSystemHelpVO> queryListDynamic(PrdSystemHelpQuery query) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 拼装查询条件
     * .
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemHelpVO> getJpaQueryWhere(PrdSystemHelpQuery query) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = getJpaQuerySelect();

        if (!ObjectUtils.isEmpty(query.getHelpNo())) {
            jpaQuery.where(qdo.helpNo.like(SqlUtil.toSqlLikeString(query.getHelpNo())));
        }
        if (!ObjectUtils.isEmpty(query.getHelpTitle())) {
            jpaQuery.where(qdo.helpTitle.like(SqlUtil.toSqlLikeString(query.getHelpTitle())));
        }
        jpaQuery.where(qdo.deleteFlag.eq(0));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemHelpVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemHelpVO.class,
                qdo.id,
                qdo.helpNo,
                qdo.helpTitle,
                qdo.articleUrl,
                qdo.linkUrl,
                qdo.remark,
                qdo.tenantId
        )).from(qdo);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PrdSystemHelpVO queryByKey(Long id) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据主键查询
     *
     * @param helpTitle 标题
     * @return 结果
     */
    public List<PrdSystemHelpVO> queryByTitle(String helpTitle) {
        JPAQuery<PrdSystemHelpVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.helpTitle.eq(helpTitle));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

}
