package com.elitesland.tw.tw5.server.prd.system.dao;

import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionFunctionObjectVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemRoleVO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdSystemPermissionFunctionObjectDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFieldDO;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdSystemPermissionFunctionObjectDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * TODO
 *
 * @author : JS
 * @date 2023/10/11
 */
@Repository
@RequiredArgsConstructor
public class PrdSystemPermissionFunctionObjectDAO {

    private final JPAQueryFactory jpaQueryFactory;

    private final QPrdSystemPermissionFunctionObjectDO qdo = QPrdSystemPermissionFunctionObjectDO.prdSystemPermissionFunctionObjectDO;

    public void deleteByIds(List<Long> ids){
        jpaQueryFactory.delete(qdo)
                .where(qdo.id.in(ids).and(qdo.deleteFlag.eq(0)))
                .execute();
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PrdSystemPermissionFunctionObjectVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PrdSystemPermissionFunctionObjectVO.class,
                qdo.id,
                qdo.objectId,
                qdo.functionId,
                qdo.className,
                qdo.classPathCode,
                qdo.classPathName,
                qdo.permissionType
        )).from(qdo);
    }

    /**
     * 根据功能ID查询功能对象
     * @param functionIds
     * @return
     */
    public List<PrdSystemPermissionFunctionObjectVO> queryByFunctionId(List<Long> functionIds) {
        JPAQuery<PrdSystemPermissionFunctionObjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.functionId.in(functionIds));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }

    /**
     * 获取功能对象的 功能主键
     *
     * @param funcObjIds
     * @return
     */
    public List<Long> getByIds(List<Long> funcObjIds) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdo.functionId).from(qdo).where(qdo.id.longValue().in(funcObjIds));
        return jpaQuery.fetch();
    }

    /**
     * 获取功能对象的 功能主键
     *
     * @param funcObjIds
     * @return
     */
    public List<PrdSystemPermissionFunctionObjectVO> getByV2Ids(List<Long> funcObjIds) {
        JPAQuery<PrdSystemPermissionFunctionObjectVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.longValue().in(funcObjIds));
        return jpaQuery.fetch();
    }

}
