package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

@Entity
@Table(name = "prd_message_config")
@org.hibernate.annotations.Table(appliesTo = "prd_message_config", comment = "消息配置表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdMessageConfigDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("消息编号")
    @Column()
    private String messageCode;

    @Comment("消息标题")
    @Column()
    private String messageTitle;

    @Comment("消息内容")
    @Column()
    private String messageContent;

    @Comment("消息类型")
    @Column()
    private String contentType;

    @Comment("消息大类")
    @Column()
    private String contentBigType;


    @Comment("发布来源")
    @Column()
    private String releaseSource;

    /**
     * 以邮箱未参数，用这个邮箱发邮件，临时方案
     */
    @Comment("发布邮箱")
    @Column()
    private String source;

    /**
     * 发布来源具体对象， （以谁的名义发布该条消息，个人，系统，组织，角色等，默认是个人）
     */
    @Comment("发布来源")
    @Column()
    private String createSource;

    @Comment("通知方式")
    @Column()
    private String noticeWay;

    @Comment("通知范围")
    @Column()
    private String noticeScope;

    @Comment("通知资源")
    @Column()
    private String noticeSource;

    @Comment("触发方式")
    @Column()
    private String triggerWay;

    @Comment("触发时间表达式")
    @Column()
    private String triggerTimeExpression;
    /**
     * 定时发布（单次发布具体时间）
     */
    @Comment("定时发布（单次发布具体时间）")
    @Column()
    private LocalDateTime triggerTime;

    @Comment("表达式说明")
    @Column()
    private String expressionExplain;

    @Comment("消息标签")
    @Column()
    private String messageTag;

    @Comment("发布状态")
    @Column()
    private Integer releaseStatus;

    @Comment("资源类型")
    @Column()
    private Integer messageType;

    @Comment("是否启用")
    @Column()
    private Integer isEnable;


    @Comment("业务数据id")
    @Column()
    private Long objectId;


    @Comment("业务数据具体业务")
    @Column()
    private String action;


}
