package com.elitesland.tw.tw5.server.prd.task.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.task.payload.PmsTaskRoutePayload;
import com.elitesland.tw.tw5.api.prd.task.query.PmsTaskRouteQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.task.service.inf.PmsTaskRouteService;
import com.elitesland.tw.tw5.api.prd.task.vo.PmsTaskRouteVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 任务路线图
 *
 * @author wangxl
 * @date 2024/4/18
 */
@RestController
@RequestMapping("/api/pmsTaskRoute")
@RequiredArgsConstructor
@Slf4j
@Api(value = "任务路线图", tags = {"任务路线图"})
public class PmsTaskRouteController {

    private final PmsTaskRouteService service;

    @ApiOperation("分页查询")
    @GetMapping("/page")
    public TwOutputUtil<PagingVO<PmsTaskRouteVO>> page(PmsTaskRouteQuery query) {
        return service.queryPage(query);
    }

    @ApiOperation("列表查询")
    @GetMapping("/list")
    public TwOutputUtil<List<PmsTaskRouteVO>> list(PmsTaskRouteQuery query) {
        return service.queryList(query);
    }

    @ApiOperation("关系列表查询")
    @GetMapping("/childList")
    public TwOutputUtil<List<PmsTaskRouteVO>> childList(PmsTaskRouteQuery query) {
        return service.childList(query);
    }


    @ApiOperation("主键查询")
    @GetMapping("/key")
    public TwOutputUtil<PmsTaskRouteVO> queryByKey(Long id) {
        return service.queryByKey(id);
    }

    @ApiOperation("新增")
    @PostMapping("/insert")
    // @DuplicateSubmissionPrevention
    public TwOutputUtil<PmsTaskRouteVO> insert(@RequestBody PmsTaskRoutePayload payload) {
        // 关键日志打印
        log.debug("【PmsTaskRouteController.insert】入参：" + payload.toString());
        return service.insert(payload);
    }

    @ApiOperation("修改")
    @PostMapping("/update")
    public TwOutputUtil<PmsTaskRouteVO> update(@RequestBody PmsTaskRoutePayload payload) {
        // 关键日志打印
        log.debug("【PmsTaskRouteController.update】入参：" + payload.toString());
        return service.update(payload);
    }

    @ApiOperation("动态修改")
    @PostMapping("/updateDynamic")
    public TwOutputUtil<PmsTaskRouteVO> updateDynamic(@RequestBody PmsTaskRoutePayload payload) {
        // 关键日志打印
        log.debug("【PmsTaskRouteController.updateDynamic】入参：" + payload.toString());
        return service.updateDynamic(payload);
    }

    @ApiOperation("删除")
    @PostMapping("/deleteSoft")
    public TwOutputUtil<Long> deleteSoft(@RequestBody List<Long> ids) {
        log.debug("【PmsTaskRouteController.deleteSoft】入参：" + ids);
        return service.deleteSoft(ids);
    }
}
