package com.elitesland.tw.tw5.server.prd.task.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.task.query.TaskInfoQuery;
import com.elitesland.tw.tw5.api.prd.task.service.TaskInfoService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoExcelExport;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.task.convert.TaskInfoConvert;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/**
 * 任务管理
 *
 * @author xxb
 * @date 2023-11-17
 */
@Api(tags = "任务管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/taskInfo")
@Slf4j
public class TaskInfoController {


    private final TaskInfoService taskInfoService;

    /***
     * 修改任务
     * @param taskInfoPayload
     * @return
     */
    @PostMapping("/updateTask")
    @ApiOperation("修改任务")
    public TwOutputUtil updateTask(@RequestBody TaskInfoPayload taskInfoPayload) {
        taskInfoService.updateTask(taskInfoPayload);
        return TwOutputUtil.ok();
    }

    /**
     * 批量新增任务
     *
     * @param taskPayload
     * @return
     */
    @PostMapping("/batchAddTask")
    @ApiOperation("批量新增任务")
    public TwOutputUtil addTask(@RequestBody TaskPayload taskPayload) {
        taskInfoService.batchAddTask(taskPayload);
        return TwOutputUtil.ok();
    }

    /**
     * 任务详情
     *
     * @param key
     * @return
     */
    @GetMapping("/taskDetail")
    @UdcNameClass
    @ApiOperation("任务详情")
    public TwOutputUtil<TaskInfoVO> taskDetail(Long key, Boolean needTaskPackage) {
        return TwOutputUtil.ok(taskInfoService.queryByKey(key, needTaskPackage));
    }

    /**
     * 任务列表
     *
     * @param taskInfoQuery
     * @return
     */
    @GetMapping("/taskList")
    @UdcNameClass
    @ApiOperation("任务列表")
    public TwOutputUtil<TaskInfoVO> taskList(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(taskInfoService.queryList(taskInfoQuery));
    }

    /**
     * 任务分页列表
     *
     * @param taskInfoQuery
     * @return
     */
    @GetMapping("/paging")
//    @UdcNameClass
    @ApiOperation("任务分页列表")
    @UdcNameClass
    public TwOutputUtil<PagingVO<TaskInfoVO>> paging(TaskInfoQuery taskInfoQuery) {
        PagingVO<TaskInfoVO> taskInfoVOPagingVO = taskInfoService.queryPage(taskInfoQuery);
        return TwOutputUtil.ok(taskInfoVOPagingVO);
    }


    /**
     * 批量导出excel
     *
     * @return result
     */
    @ApiOperation("批量导出excel")
    @PostMapping("/batchExport")
    @UdcNameClass
    public void permissionBatchExport(HttpServletResponse response, @RequestBody TaskInfoQuery query) throws IOException {
        log.info("批量导出excel");
        taskInfoService.batchExport(response, query);

    }


    /**
     * 当量调整--变更
     *
     * @param payload
     * @return
     */
    @PostMapping("/saveChangeLog")
    @ApiOperation("当量调整--变更")
    public TwOutputUtil saveChangeLog(@RequestBody TaskInfoPayload payload) {
        taskInfoService.saveChangeLog(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 任务分解
     *
     * @param taskPayload
     * @return
     */
    @PostMapping("/taskDecompose")
    @ApiOperation("任务分解")
    public TwOutputUtil taskDecompose(@RequestBody TaskPayload taskPayload) {
        taskInfoService.taskDecompose(taskPayload);
        return TwOutputUtil.ok();
    }

    /**
     * 任务-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskInfoService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 任务申请
     *
     * @param taskPayload
     * @return
     */
    @PostMapping("/apply")
    @ApiOperation("任务申请")
    public TwOutputUtil apply(@RequestBody TaskPayload taskPayload) {
        taskInfoService.taskApply(taskPayload);
        return TwOutputUtil.ok();
    }

    /**
     * 任务完工申请
     *
     * @param keys
     * @return
     */
    @GetMapping("/taskFinish")
    @ApiOperation("任务完工申请")
    public TwOutputUtil finish(Long[] keys) {
        taskInfoService.taskFinish(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 任务关闭
     *
     * @param keys
     * @return
     */
    @GetMapping("/taskClose")
    @ApiOperation("任务关闭")
    public TwOutputUtil taskClose(Long[] keys) {
        taskInfoService.taskClose(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 处理任务完工申请
     *
     * @param key             任务主键
     * @param operationStatus 操作状态：0：拒绝，1：同意
     * @return
     */
    @GetMapping("/operationTaskFinish")
    @ApiOperation("处理任务完工申请")
    public TwOutputUtil operationTaskFinish(Long key, String operationStatus) {
        taskInfoService.operationTaskFinish(key, operationStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 更改任务进度
     *
     * @param key
     * @param progress
     * @return
     */
    @GetMapping("/updateTaskProgress")
    @ApiOperation("更改任务进度")
    public TwOutputUtil updateTaskProgress(Long key, BigDecimal progress) {
        taskInfoService.updateTaskProgress(key, progress);
        return TwOutputUtil.ok();
    }

    /**
     * 任务派发
     *
     * @param keys
     * @return
     */
    @GetMapping("/taskAssign")
    @ApiOperation("任务派发")
    public TwOutputUtil taskAssign(Long[] keys) {
        taskInfoService.taskAssign(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping("/queryListCommon")
    @UdcNameClass
    @ApiOperation("通用任务列表")
    public TwOutputUtil<TaskInfoVO> queryListCommon(TaskInfoQuery taskInfoQuery) {
        return TwOutputUtil.ok(taskInfoService.queryListCommon(taskInfoQuery));
    }
}
