package com.elitesland.tw.tw5.server.prd.task.entity;


import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * 任务路线图明细DO
 * @author wangxl
 * @date 2024-1-18
 */
@Entity
@Table(name = "pms_task_route_dtl")
@org.hibernate.annotations.Table(appliesTo = "pms_task_route_dtl", comment = "任务路线图明细")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PmsTaskRouteDtlDO extends BaseModel {

    /**
     * 任务id
     */
    @Comment("任务id")
    @Column
    private Long taskId;

    /**
     * 执行项说明
     */
    @Comment("执行项说明")
    @Column
    private String executionDesc;

    /**
     * 上级id
     */
    @Comment("上级id")
    @Column
    private Long parentId;

    /**
     * 项目id
     */
    @Comment("项目id")
    @Column
    private Long projectId;

    /**
     * 路线图id
     */
    @Comment("路线图id")
    @Column
    private Long masId;

}
