package com.elitesland.tw.tw5.server.prd.taskpro.constants;

import lombok.Getter;

/**
 * 任务事由类型枚举
 * 新版pms采用
 *
 * @author duwh
 */
public enum TaskReasonTypeEnum {
    PROJ_CONTRACT("PROJ_CONTRACT", "项目"),

    ;

    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    TaskReasonTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TaskReasonTypeEnum getByCode(String code) {
        for (TaskReasonTypeEnum value : TaskReasonTypeEnum.values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }
}
