package com.elitesland.tw.tw5.server.prd.taskpro.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskScenePayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 任务场景
 *
 * @author duwh
 * @date 2024-01-31
 */
@Api(tags = "任务场景")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/pms/taskScene")
@Slf4j
public class TaskSceneController {

    private final TaskSceneService taskSceneService;

    /**
     * 任务场景-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("任务场景-新增")
    public TwOutputUtil<TaskSceneVO> insert(@RequestBody TaskScenePayload payload) {
        return TwOutputUtil.ok(taskSceneService.insert(payload));
    }

    /**
     * 任务场景-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("任务场景-更新")
    public TwOutputUtil<TaskSceneVO> update(@RequestBody TaskScenePayload payload) {
        return TwOutputUtil.ok(taskSceneService.update(payload));
    }

    /**
     * 任务场景-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("任务场景-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TaskScenePayload payload) {
        return TwOutputUtil.ok(taskSceneService.updateByKeyDynamic(payload));
    }

    /**
     * 任务场景-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("任务场景-主键查询")
    public TwOutputUtil<TaskSceneVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(taskSceneService.queryByKey(key));
    }

    /**
     * 任务场景-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("任务场景-分页")
    public TwOutputUtil<PagingVO<TaskSceneVO>> paging(TaskSceneQuery query) {
        return TwOutputUtil.ok(taskSceneService.queryPaging(query));
    }

    /**
     * 任务场景-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("任务场景-查询列表")
    public TwOutputUtil<List<TaskSceneVO>> queryList(TaskSceneQuery query) {
        return TwOutputUtil.ok(taskSceneService.queryListDynamic(query));
    }

    @GetMapping("/listByRef")
    // @UdcNameClass
    @ApiOperation("任务类别-查询列表，查询未被场景使用的数据")
    public TwOutputUtil<List<TaskSceneVO>> listByRef(TaskCategoryQuery query) {
        return TwOutputUtil.ok(taskSceneService.listByRef(query));
    }

    /**
     * 任务场景-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务场景-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        taskSceneService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
