package com.elitesland.tw.tw5.server.prd.taskpro.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskCategoryPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;

import java.util.List;

/**
 * 任务类别
 *
 * @author duwh
 * @date 2024-01-31
 */
public interface TaskCategoryService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskCategoryVO}>
     */
    PagingVO<TaskCategoryVO> queryPaging(TaskCategoryQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskCategoryVO}>
     */
    List<TaskCategoryVO> queryListDynamic(TaskCategoryQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskCategoryVO}
     */
    TaskCategoryVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskCategoryVO}
     */
    TaskCategoryVO insert(TaskCategoryPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskCategoryVO}
     */
    TaskCategoryVO update(TaskCategoryPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TaskCategoryPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

}
