package com.elitesland.tw.tw5.server.prd.taskpro.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskMemberRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskMemberRefQuery;

import java.util.List;

/**
 * 通用任务成员关系
 *
 * @author duwh
 * @date 2024-02-01
 */
public interface TaskMemberRefService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskMemberRefVO}>
     */
    PagingVO<TaskMemberRefVO> queryPaging(TaskMemberRefQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskMemberRefVO}>
     */
    List<TaskMemberRefVO> queryListDynamic(TaskMemberRefQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskMemberRefVO}
     */
    TaskMemberRefVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskMemberRefVO}
     */
    TaskMemberRefVO insert(TaskMemberRefPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskMemberRefVO}
     */
    TaskMemberRefVO update(TaskMemberRefPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TaskMemberRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    long deleteSoftByTaskId(Long taskId);
}
