package com.elitesland.tw.tw5.server.prd.taskpro.service;


import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskProPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProBoardViewGroupInfoVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
public interface TaskProService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskProVO}>
     */
    PagingVO<TaskProVO> queryPaging(TaskProQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskProVO}>
     */
    List<TaskProVO> queryListDynamic(TaskProQuery query);

    /**
     * 计数
     *
     * @param query 查询
     * @return {@link Long}
     */
    Long count(TaskProQuery query);

    /**
     * 树
     *
     * @param query 查询
     * @return {@link List}<{@link TaskProVO}>
     */
    List<TaskProVO> tree(TaskProQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskProVO}
     */
    TaskProVO queryByKey(Long key);

    void translate(TaskProVO vo);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskProVO}
     */
    TaskProVO insert(TaskProPayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskProVO}
     */
    TaskProVO update(TaskProPayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TaskProPayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    /**
     * 置顶
     *
     * @param payload 有效载荷
     * @return long
     */
    long top(TaskProPayload payload);

    Boolean updatePartiesId(List<TaskProQuery> taskProQueryList);

    /**
     * 创建子任务
     *
     * @param payload 有效载荷
     * @return {@link TaskProVO}
     */
    TaskProVO createSub(TaskProPayload payload);

    /**
     * 板视图组
     *
     * @param query 查询
     * @return {@link List}<{@link TaskProBoardViewGroupInfoVO}>
     */
    List<TaskProBoardViewGroupInfoVO> boardViewGroup(TaskProQuery query);

    /**
     * 板视图
     *
     * @param query 查询
     * @return {@link List}<{@link TaskProBoardVO}>
     */
    List<TaskProBoardVO> boardView(TaskProQuery query);

    /**
     * 子任务父任务解绑
     *
     * @param subTaskId    子任务id
     * @param parentTaskId 父任务id
     * @return {@link Boolean}
     */
    Boolean unbindRef(Long subTaskId, Long parentTaskId);

    List<TaskProVO> queryListDynamicForExcelExport(TaskProQuery query);

    Boolean updateBatch(List<TaskProPayload> payloadList);


    /**
     * 活动进度汇总
     * $$\text{{活动进度}} = \sum_{\text{{每个任务}}} \text{{任务进度}}  \times \frac
     * {\text{{任务预估工时}}}{该任务归属的活动下所有任务的预估工时}$$
     * @param wbsId
     * @return
     */
    BigDecimal summaryWbs(Long wbsId, String type);

    /**
     * 按任务id和具有wbs id查询列表
     *
     * @param taskIds 任务ID
     * @return {@link List}<{@link TaskProVO}>
     */
    List<TaskProVO> queryListByTaskIdsAndHaveWbsId(List<Long> taskIds);
}
