package com.elitesland.tw.tw5.server.prd.taskpro.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskScenePayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskSceneVO;


import java.util.List;

/**
 * 任务场景
 *
 * @author duwh
 * @date 2024-01-31
 */
public interface TaskSceneService {

    /**
     * 分页列表
     *
     * @param query 条件
     * @return {@link PagingVO}<{@link TaskSceneVO}>
     */
    PagingVO<TaskSceneVO> queryPaging(TaskSceneQuery query);

    /**
     * 查询列表
     *
     * @param query 条件参数
     * @return {@link List}<{@link TaskSceneVO}>
     */
    List<TaskSceneVO> queryListDynamic(TaskSceneQuery query);

    /**
     * 通过主键查询
     *
     * @param key 主键
     * @return {@link TaskSceneVO}
     */
    TaskSceneVO queryByKey(Long key);

    /**
     * 新增
     *
     * @param payload 单据数据
     * @return {@link TaskSceneVO}
     */
    TaskSceneVO insert(TaskScenePayload payload);

    /**
     * 修改
     *
     * @param payload 单据数据
     * @return {@link TaskSceneVO}
     */
    TaskSceneVO update(TaskScenePayload payload);

    /**
     * 修改,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 单据数据
     * @return {@link long}
     */
    long updateByKeyDynamic(TaskScenePayload payload);

    /**
     * 逻辑删除
     *
     * @param keys 主键集合
     */
    void deleteSoft(List<Long> keys);

    List<TaskCategoryVO> listByRef(TaskCategoryQuery query);

    /**
     * 统计数据
     * @param taskSceneQuery
     * @return
     */
    Long count(TaskSceneQuery taskSceneQuery);
}
