package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskCategoryConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskCategoryDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskCategoryPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskCategoryQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskSceneQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskCategoryRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskCategoryDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskSceneService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

/**
 * 任务类别
 *
 * @author duwh
 * @date 2024-01-31
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskCategoryServiceImpl extends BaseServiceImpl implements TaskCategoryService {

    private final TaskCategoryRepo taskCategoryRepo;
    private final TaskCategoryDAO taskCategoryDAO;

    private final StateFlowService stateFlowService;

    @Autowired
    @Lazy
    private TaskSceneService taskSceneService;

    @Resource
    @Lazy
    private TaskProService taskProService;

    @Override
    public PagingVO<TaskCategoryVO> queryPaging(TaskCategoryQuery query) {
        return taskCategoryDAO.queryPaging(query);
    }

    @Override
    public List<TaskCategoryVO> queryListDynamic(TaskCategoryQuery query) {

        List<TaskCategoryVO> taskCategoryVOS = taskCategoryDAO.queryListDynamic(query);
        taskCategoryVOS.forEach(taskCategoryVO -> {
            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(taskCategoryVO.getId());
            List<StateFlowVO> stateFlowVOS = stateFlowService.getList(stateFlowQuery);
            taskCategoryVO.setStateFlowConfigVOList(stateFlowVOS);
        });
        return taskCategoryVOS;
    }

    @Override
    public TaskCategoryVO queryByKey(Long key) {
        TaskCategoryDO entity = taskCategoryRepo.findById(key).orElseGet(TaskCategoryDO::new);
        Assert.notNull(entity.getId(), "任务类别不存在");
        TaskCategoryVO vo = TaskCategoryConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskCategoryVO insert(TaskCategoryPayload payload) {
        // 校验
        check(payload);

        // 唯一性校验
        uniquenessVerification(payload);
        TaskCategoryDO entityDo = TaskCategoryConvert.INSTANCE.toDo(payload);
        return TaskCategoryConvert.INSTANCE.toVo(taskCategoryRepo.save(entityDo));
    }

    /**
     * 唯一性验证
     *
     * @param payload 有效载荷
     */
    private void uniquenessVerification(TaskCategoryPayload payload) {
        TaskCategoryQuery categoryQuery = new TaskCategoryQuery();
        categoryQuery.setNameEq(payload.getName());
        categoryQuery.setIdNeq(payload.getId());
        long count = taskCategoryDAO.count(categoryQuery);
        if (count > 0) {
            throw TwException.error("", "该状态流名称的数据已存在！");
        }
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(TaskCategoryPayload payload) {
        Assert.hasText(payload.getName(), "任务类别名称不能为空");
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskCategoryVO update(TaskCategoryPayload payload) {
        TaskCategoryDO entity = taskCategoryRepo.findById(payload.getId()).orElseGet(TaskCategoryDO::new);
        Assert.notNull(entity.getId(), "任务类别不存在");
        // 校验
        check(payload);
        // 唯一性校验
        uniquenessVerification(payload);

        TaskCategoryDO entityDo = TaskCategoryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskCategoryConvert.INSTANCE.toVo(taskCategoryRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TaskCategoryPayload payload) {
        TaskCategoryDO entity = taskCategoryRepo.findById(payload.getId()).orElseGet(TaskCategoryDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = taskCategoryDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.forEach(key -> {
//                TaskProQuery taskProQuery = new TaskProQuery();
//                taskProQuery.setTaskCategoryId(key);
//                Long count = taskProService.count(taskProQuery);
//                if (count > 0) {
//                    throw TwException.error("", "该类别下存在任务，不能删除！");
//                }
                // 关联的任务流查询
                TaskSceneQuery taskSceneQuery = new TaskSceneQuery();
                taskSceneQuery.setCategoryId(key);
                Long count = taskSceneService.count(taskSceneQuery);
                if (count > 0) {
                    throw new BusinessException("该状态流已关联任务流，不能删除");
                }

            });
            taskCategoryDAO.deleteSoft(keys);
        }
    }

}
