package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import org.springframework.util.Assert;

import java.math.BigDecimal;

/**
 * 任务成本 工具类
 *
 * @author duwh
 * @date 2024/03/06
 */
public class TaskProCostUtil {

    /**
     * 计算任务成本
     * 公式  角色单价*预估公式/项目日历中的工作时间
     *
     * @param unitPrice        单价
     * @param predictWorkHours 预测工作时间
     * @param workHours        工作时间
     * @return {@link BigDecimal}
     */
    public static BigDecimal calculateTaskCost(BigDecimal unitPrice, BigDecimal predictWorkHours, BigDecimal workHours) {
        Assert.notNull(unitPrice, "unitPrice不能为空");
        Assert.notNull(predictWorkHours, "predictWorkHours不能为空");
        Assert.notNull(workHours, "项目工作时间未维护");
        return unitPrice.multiply(predictWorkHours).divide(workHours, 2, BigDecimal.ROUND_HALF_UP);
    }
}
