package com.elitesland.tw.tw5.server.prd.taskpro.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.personplan.query.ProRelatedPartiesQuery;
import com.elitesland.tw.tw5.api.prd.personplan.service.PmsProjectRoleService;
import com.elitesland.tw.tw5.api.prd.personplan.service.ProRelatedPartiesService;
import com.elitesland.tw.tw5.api.prd.personplan.vo.PmsProjectRoleVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.ProRelatedPartiesVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskMemberRefVO;
import com.elitesland.tw.tw5.api.prd.personplan.vo.TaskProVO;
import com.elitesland.tw.tw5.api.prd.pms.budget.service.PmsWbsBudgetDetailsService;
import com.elitesland.tw.tw5.api.prd.pms.budget.vo.PmsWbsBudgetDetailsVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectWbsService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsResourceVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectWbsVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskProBoardVO;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.constants.ComLogTypeEnum;
import com.elitesland.tw.tw5.server.common.constants.ProjectWbsStatusEnum;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.query.StateFlowQuery;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.model.vo.StateFlowVO;
import com.elitesland.tw.tw5.server.prd.pms.stateflow.service.StateFlowService;
import com.elitesland.tw.tw5.server.prd.provacation.model.query.ProVacationSettingQuery;
import com.elitesland.tw.tw5.server.prd.provacation.model.vo.ProVacationSettingVO;
import com.elitesland.tw.tw5.server.prd.provacation.service.ProVacationSettingService;
import com.elitesland.tw.tw5.server.prd.taskpro.constants.*;
import com.elitesland.tw.tw5.server.prd.taskpro.convert.TaskProConvert;
import com.elitesland.tw.tw5.server.prd.taskpro.model.entity.TaskProDO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskMemberRefPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.payload.TaskProPayload;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskMemberRefQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.query.TaskProQuery;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskCategoryVO;
import com.elitesland.tw.tw5.server.prd.taskpro.model.vo.TaskProBoardViewGroupInfoVO;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.TaskProRepo;
import com.elitesland.tw.tw5.server.prd.taskpro.repo.dao.TaskProDAO;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskCategoryService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskMemberRefService;
import com.elitesland.tw.tw5.server.prd.taskpro.service.TaskProService;
import com.elitesland.tw.tw5.server.prd.taskpro.support.TaskProEventFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 任务主档
 *
 * @author duwh
 * @date 2024-02-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TaskProServiceImpl extends BaseServiceImpl implements TaskProService {


    private final TaskProRepo taskProRepo;
    private final TaskProDAO taskProDAO;
    private final TaskMemberRefService taskMemberRefService;
    private final TaskCategoryService taskCategoryService;
    @Resource
    private ProRelatedPartiesService proRelatedPartiesService;
    private final StateFlowService stateFlowService;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final PrdSystemLogService logService;
    private final PmsProjectWbsService pmsProjectWbsService;
    // 项目日历设置
    private final ProVacationSettingService proVacationSettingService;
    // 相关方角色
    private final PmsProjectRoleService pmsProjectRoleService;
    @Resource
    private PmsWbsBudgetDetailsService pmsWbsBudgetDetailsService;

    @Override
    public PagingVO<TaskProVO> queryPaging(TaskProQuery query) {
        List<OrderItem> taskOrderItemList = new ArrayList<>();
        taskOrderItemList.add(OrderItem.desc("topFlag"));
        taskOrderItemList.add(OrderItem.desc("topModifyTime"));
        taskOrderItemList.add(OrderItem.desc("sort"));
        taskOrderItemList.add(OrderItem.desc("createTime"));
        query.setOrders(taskOrderItemList);
        if (ObjectUtils.isEmpty(query.getSearchType())) {
            query.setSearchType(TaskProGroupEnum.ALL_ALL.getCode());
        }
        String searchType = query.getSearchType();
        PagingVO<TaskProVO> pagingVO = PagingVO.empty();
        Long reasonId = query.getReasonId();
        if (searchType.equals(TaskProGroupEnum.ALL_ALL.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            // 根据当前登录人、获取其相对方的主键
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            Set<Long> relatedIdList = listSimple.stream().map(ProRelatedPartiesVO::getId).collect(Collectors.toSet());
            query.setRelatedIdList(relatedIdList);
            if (CollectionUtils.isEmpty(query.getRelatedIdList())) {
                relatedIdList.add(9999L);
                query.setRelatedIdList(relatedIdList);
            }
            pagingVO = taskProDAO.queryPaging(query);
            // 我创建的
        } else if (searchType.equals(TaskProGroupEnum.MY_CREATE.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            // 项目维度下
            if (null != reasonId) {
                // 根据当前登录人、获取其相对方的主键
                List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
                if (!CollectionUtils.isEmpty(listSimple)) {
                    ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                    Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                    query.setCreateRelatedPartiesId(relatedPartiesVOId);
                    pagingVO = taskProDAO.queryPaging(query);
                }
            } else {
                query.setCreateUserId(loginUserId);
                pagingVO = taskProDAO.queryPaging(query);
            }
            // 我负责的
        } else if (searchType.equals(TaskProGroupEnum.MY_DIRECTOR.getCode())) {

            Assert.notNull(reasonId, "请选择项目，参数缺失");
            Long loginUserId = GlobalUtil.getLoginUserId();
            // 根据项目id、当前登录人、获取其相对方的主键  并统计相应任务个数
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                query.setDirectorRelatedPartiesId(relatedPartiesVOId);
                pagingVO = taskProDAO.queryPaging(query);
            }
            // 我关注的
        } else if (searchType.equals(TaskProGroupEnum.MY_FOLLOW.getCode())) {
            Assert.notNull(reasonId, "请选择项目，参数缺失");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                // 我关注的
                pagingVO = taskProDAO.queryPagingLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.FOLLOW.getCode());
            }
            // 我参与的
        } else if (searchType.equals(TaskProGroupEnum.MY_PART.getCode())) {
            Assert.notNull(reasonId, "请选择项目，参数缺失");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                // 我参与的
                pagingVO = taskProDAO.queryPagingLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.PART.getCode());
            }
        } else {
            pagingVO = taskProDAO.queryPaging(query);
        }


        pagingVO.getRecords().forEach(vo -> translate(vo));
        return pagingVO;
    }

    /**
     * 根据项目主键、当前登录人 获取相对方主键
     *
     * @param reasonId    原因id
     * @param loginUserId 登录用户id
     * @return {@link List}<{@link ProRelatedPartiesVO}>
     */
    private List<ProRelatedPartiesVO> getProRelatedPartiesVOS(Long reasonId, Long loginUserId) {
        // 根据项目id、当前登录人、获取其相对方的主键  并统计相应任务个数
        ProRelatedPartiesQuery relatedPartiesQuery = new ProRelatedPartiesQuery();
        relatedPartiesQuery.setProId(reasonId);
        relatedPartiesQuery.setUserId(loginUserId);
        List<ProRelatedPartiesVO> listSimple = proRelatedPartiesService.getListSimple(relatedPartiesQuery);
        return listSimple;
    }

    @Override
    public List<TaskProVO> queryListDynamic(TaskProQuery query) {
        List<OrderItem> taskOrderItemList = new ArrayList<>();
        taskOrderItemList.add(OrderItem.desc("topFlag"));
        taskOrderItemList.add(OrderItem.desc("topModifyTime"));
        taskOrderItemList.add(OrderItem.desc("sort"));
        taskOrderItemList.add(OrderItem.desc("createTime"));
        query.setOrders(taskOrderItemList);
        return taskProDAO.queryListDynamic(query);
    }

    @Override
    public Long count(TaskProQuery query) {
        return taskProDAO.count(query);
    }

    @Override
    public List<TaskProVO> tree(TaskProQuery query) {
        List<OrderItem> taskOrderItemList = new ArrayList<>();
        taskOrderItemList.add(OrderItem.desc("topFlag"));
        taskOrderItemList.add(OrderItem.desc("topModifyTime"));
        taskOrderItemList.add(OrderItem.desc("sort"));
        taskOrderItemList.add(OrderItem.desc("createTime"));
        query.setOrders(taskOrderItemList);
        List<TaskProVO> taskProVOS = taskProDAO.queryListDynamic(query);
        // 转树形结构
        List<TaskProVO> tree = buildTree(taskProVOS);
        return tree;
    }

    public List<TaskProVO> buildTree(List<TaskProVO> categoryVOList) {
        List<TaskProVO> trees = new ArrayList<>();
        Set<Long> ids = new HashSet<>();
        for (TaskProVO categoryDTO : categoryVOList) {
            if (categoryDTO.getParentId() == null) {
                trees.add(categoryDTO);
            }
            for (TaskProVO it : categoryVOList) {
                if (categoryDTO.getId().equals(it.getParentId())) {
                    if (categoryDTO.getChildren() == null) {
                        categoryDTO.setChildren(new ArrayList<>());
                    }
                    categoryDTO.getChildren().add(it);
                    ids.add(it.getId());
                }
            }
        }
        if (trees.size() == 0) {
            trees = categoryVOList.stream().filter(s -> !ids.contains(s.getId())).collect(Collectors.toList());
        }
        return trees;
    }

    @Override
    public TaskProVO queryByKey(Long key) {
        TaskProDO entity = taskProRepo.findById(key).orElseGet(TaskProDO::new);
        Assert.notNull(entity.getId(), "任务不存在");
        TaskProVO vo = TaskProConvert.INSTANCE.toVo(entity);

        //翻译
        translate(vo);
        return vo;
    }

    /**
     * 翻译
     *
     * @param vo vo
     */
    @Override
    public void translate(TaskProVO vo) {
        Long taskId = vo.getId();
        // 翻译人员
        TaskMemberRefQuery taskMemberRefQuery = new TaskMemberRefQuery();
        taskMemberRefQuery.setTaskId(taskId);
        taskMemberRefQuery.setType(TaskMemberRefTypeEnum.RELATED.getCode());
        List<TaskMemberRefVO> taskMemberRefVOS = taskMemberRefService.queryListDynamic(taskMemberRefQuery);
        vo.setTaskMemberRefList(taskMemberRefVOS);
        List<Long> memberFollowIdList = taskMemberRefVOS.stream()
                .filter(taskMemberRefVO -> taskMemberRefVO.getObjType().equals(TaskMemberRefObjTypeEnum.FOLLOW.getCode()))
                .map(TaskMemberRefVO::getObjId).collect(Collectors.toList());
        vo.setMemberFollowIdList(memberFollowIdList);
        if (!CollectionUtils.isEmpty(memberFollowIdList)) {
            // 相关方翻译
            ProRelatedPartiesQuery proRelatedPartiesFollowQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesFollowQuery.setIdList(memberFollowIdList);
            List<ProRelatedPartiesVO> memberFollowVos = proRelatedPartiesService.getList(proRelatedPartiesFollowQuery);
            List<String> memberFollowNameList = memberFollowVos.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.toList());
            vo.setMemberFollowNameList(memberFollowNameList);

        }

        // 参与人
        List<Long> memberPartIdList = taskMemberRefVOS.stream()
                .filter(taskMemberRefVO -> taskMemberRefVO.getObjType().equals(TaskMemberRefObjTypeEnum.PART.getCode()))
                .map(TaskMemberRefVO::getObjId).collect(Collectors.toList());
        vo.setMemberPartIdList(memberPartIdList);
        if (!CollectionUtils.isEmpty(memberPartIdList)) {
            // 相关方翻译
            ProRelatedPartiesQuery proRelatedPartiesPartQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesPartQuery.setIdList(memberPartIdList);
            List<ProRelatedPartiesVO> memberPartVos = proRelatedPartiesService.getList(proRelatedPartiesPartQuery);
            List<String> memberPartNameList = memberPartVos.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.toList());
            vo.setMemberPartNameList(memberPartNameList);

        }

        // // 负责人
        // if (null != vo.getDirectorRelatedPartiesId()) {
        //     ProRelatedPartiesVO proRelatedPartiesVO = proRelatedPartiesService.getSimple(vo.getDirectorRelatedPartiesId());
        //     vo.setDirectorRelatedPartiesName(proRelatedPartiesVO.getName());
        // }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskProVO insert(TaskProPayload payload) {
        // 数据校验
        check(payload);

        // 数据初始化
        initData(payload);

        TaskProDO entityDo = TaskProConvert.INSTANCE.toDo(payload);
        TaskProDO save = taskProRepo.save(entityDo);
        Long taskId = save.getId();

        // 任务相关人数据处理
        StringBuilder fieldsUpdateLog = new StringBuilder();
        taskMemberDataProcess(fieldsUpdateLog, payload, taskId);

        //记录变更日志
        logService.saveNewLog(entityDo.getId(), ComLogTypeEnum.PMS_TASK_PRO.getCode(), "创建了任务");

        if (save.getWbsId() != null) {
            // 基于活动的任务创建完成，触发活动清单状态 -> 开始
            TaskProEventFactory.SERVICE_MAP.forEach((taskProEventEnum, taskProEventService) -> {
                taskProEventService.taskCreateOk(save);
                // if (taskProEventEnum.equals(TaskProEventEnum.WBS_ACT_LIST)) {
                //     TaskProEventFactory.SERVICE_MAP.get(TaskProEventEnum.WBS_ACT_LIST).taskCreateOk(save);
                // }
            });
        }


        return TaskProConvert.INSTANCE.toVo(save);
    }

    private void check(TaskProPayload payload) {
        // 根据当前登录人 查询是否在项目中存在
        if (!ObjectUtils.isEmpty(payload.getReasonType()) && payload.getReasonType().equals(TaskReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            Long reasonId = payload.getReasonId();
            Assert.notNull(reasonId, "reasonId不能为空");

            Long loginUserId = GlobalUtil.getLoginUserId();
            // 根据项目id、当前登录人、获取其相对方的主键
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (CollectionUtils.isEmpty(listSimple)) {
                throw TwException.error("", "您未加入当前项目，无权限创建任务");
            }
            ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
            Long relatedPartiesVOId = proRelatedPartiesVO.getId();
            payload.setCreateRelatedPartiesId(relatedPartiesVOId);
            payload.setCreateRelatedPartiesName(proRelatedPartiesVO.getName());
        }

        Assert.hasText(payload.getTaskName(), "任务标题不能为空");
        Assert.notNull(payload.getTaskCategoryId(), "任务类别不能为空");
        Assert.notNull(payload.getPriority(), "优先级不能为空");
        Assert.notNull(payload.getDirectorRelatedPartiesId(), "负责人不能为空");
        Assert.notNull(payload.getPlanStartDate(), "开始时间不能为空");
        Assert.notNull(payload.getPlanEndDate(), "结束时间不能为空");

        // 校验活动预算
        Long wbsId = payload.getWbsId();
        if (null != wbsId) {
            PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsService.queryByKey(wbsId);
            Long directorRelatedPartiesId = payload.getDirectorRelatedPartiesId();
            //  校验活动预算
            checkWbsBudget(payload, directorRelatedPartiesId, wbsId, pmsProjectWbsVO);
        }

        // BigDecimal taskCost = TaskProCostUtil.calculateTaskCost(payload.getDirectorRelatedPartiesId(), payload.getPlanStartDate(), payload.getPlanEndDate());


    }

    /**
     * 检查wbs预算
     *
     * @param payload                  有效载荷
     * @param directorRelatedPartiesId 董事关联方id
     * @param wbsId                    wbs id
     * @param pmsProjectWbsVO          永磁同步电机项目wbs-vo
     */
    private void checkWbsBudget(TaskProPayload payload, Long directorRelatedPartiesId, Long wbsId, PmsProjectWbsVO pmsProjectWbsVO) {
        // 计算出任务所用预算
        // 公式  角色单价*预估公式/项目日历中的工作时间

        // 项目日历中的工作时间
        BigDecimal workHours = null;
        // 人天单价
        BigDecimal unitPrice = null;
        // 预估工时
        BigDecimal predictWorkHours = payload.getPredictWorkHours();
        ProVacationSettingQuery vacationSettingQuery = new ProVacationSettingQuery();
        int year = LocalDate.now().getYear();
        vacationSettingQuery.setYear(year);
        vacationSettingQuery.setProjectId(payload.getReasonId());
        List<ProVacationSettingVO> list = proVacationSettingService.getList(vacationSettingQuery);
        if (!CollectionUtils.isEmpty(list)) {
            ProVacationSettingVO proVacationSettingVO = list.get(0);
            workHours = proVacationSettingVO.getWorkHours();
        }/* else {
            throw TwException.error("", "项目日历中的工作时间未维护，请联系项目经理！");
        }*/
        Long directorRelatedPartiesRoleId = payload.getDirectorRelatedPartiesRoleId();
        if (null != directorRelatedPartiesRoleId) {
            PmsProjectRoleVO pmsProjectRoleVO = pmsProjectRoleService.queryByKey(directorRelatedPartiesRoleId);
            unitPrice = pmsProjectRoleVO.getUnitPrice();
        } else {
            ProRelatedPartiesVO proRelatedPartiesVO = proRelatedPartiesService.get(directorRelatedPartiesId);
            //TODO 多个角色 先随机取一个，后续迭代为关系表  多个角色 前端会展示多条数据，角色 id由前端传输过来
            String proRole = proRelatedPartiesVO.getProRole();
            if (StringUtils.hasText(proRole)) {
                String[] split = proRole.split(",");
                proRole = split[0];
                PmsProjectRoleVO pmsProjectRoleVO = pmsProjectRoleService.queryByKey(Long.valueOf(proRole));
                unitPrice = pmsProjectRoleVO.getUnitPrice();
            }
        }
        if (null != unitPrice && null != predictWorkHours && null != workHours) {
            BigDecimal taskCost = TaskProCostUtil.calculateTaskCost(unitPrice, predictWorkHours, workHours);
            log.info("任务成本金额：{}", taskCost);
            PmsWbsBudgetDetailsVO wbsBudgetDetailsVO = pmsWbsBudgetDetailsService.getByWbsId(wbsId, payload.getReasonId());
            if (null == wbsBudgetDetailsVO) {
                throw TwException.error("", "任务关联的WBS不存在预算信息");
            }
            // 计算结果需要小于等于该任务关联的活动的资源预算，遇到除不尽的情况进行保留小数点后两位，当任务的成本金额大于资源预算金额则无法进行新建任务操作（弹窗提醒）
            BigDecimal allocatedResAmt = wbsBudgetDetailsVO.getAllocatedResAmt() == null ? BigDecimal.ZERO : wbsBudgetDetailsVO.getAllocatedResAmt();
            log.info("任务关联的WBS预算金额：{}", allocatedResAmt);
            BigDecimal occupiedResAmt = wbsBudgetDetailsVO.getOccupiedResAmt() == null ? BigDecimal.ZERO : wbsBudgetDetailsVO.getOccupiedResAmt();
            log.info("任务关联的WBS已占用金额：{}", occupiedResAmt);
            BigDecimal settledResAmt = wbsBudgetDetailsVO.getSettledResAmt() == null ? BigDecimal.ZERO : wbsBudgetDetailsVO.getSettledResAmt();
            log.info("任务关联的WBS已结转金额：{}", settledResAmt);
            // 剩余余额 = 预算金额 - 已占用金额 - 已结算金额
            BigDecimal remainResAmt = allocatedResAmt.subtract(occupiedResAmt).subtract(settledResAmt);
            log.info("任务关联的WBS剩余金额：{}", remainResAmt);
            // 判断预算金额是否足够
            if (taskCost.compareTo(remainResAmt) > 0) {
                // 活动负责人
                // String managerUserName = pmsProjectWbsVO.getManagerUserName();
                String managerUserName = "";
                List<PmsProjectWbsResourceVO> pmsProjectWbsResourceVOList = pmsProjectWbsVO.getPmsProjectWbsResourceVOList();
                if (!CollectionUtils.isEmpty(pmsProjectWbsResourceVOList)) {
                    Optional<PmsProjectWbsResourceVO> first = pmsProjectWbsResourceVOList.stream().filter(pmsProjectWbsResourceVO -> pmsProjectWbsResourceVO.getManagerUserFlag().equals(true)).findFirst();
                    if (first.isPresent()) {
                        PmsProjectWbsResourceVO pmsProjectWbsResourceVO = first.get();
                        String relatePartiesName = pmsProjectWbsResourceVO.getRelatePartiesName();
                        managerUserName = relatePartiesName;
                    }
                }
                log.info("活动负责人：{}", managerUserName);
                // 提示  已超过活动预算，请先联系活动负责人：xxx
                throw TwException.error("", "任务成本金额大于剩余预算金额，请先联系活动负责人：" + managerUserName);
            }
        }
    }


    private void initData(TaskProPayload payload) {
        // 编号
        String taskNo = generateSeqNum(GenerateSeqNumConstants.PMS_TASK_PRO);
        payload.setTaskNo(taskNo);

        // 类别
        Long taskCategoryId = payload.getTaskCategoryId();
        if (taskCategoryId != null) {
            TaskCategoryVO taskCategoryVO = taskCategoryService.queryByKey(taskCategoryId);
            if (taskCategoryVO != null) {
                payload.setTaskCategoryName(taskCategoryVO.getName());
            }
            StateFlowQuery stateFlowQuery = new StateFlowQuery();
            stateFlowQuery.setObjId(taskCategoryId);
            stateFlowQuery.setSize(1);
            OrderItem orderItem = OrderItem.desc("sort");
            OrderItem orderItem2 = OrderItem.asc("createTime");
            List<OrderItem> orderItemList = new ArrayList<>();
            orderItemList.add(orderItem);
            orderItemList.add(orderItem2);
            stateFlowQuery.setOrders(orderItemList);
            PagingVO<StateFlowVO> page = stateFlowService.page(stateFlowQuery);
            if (page.getTotal() < 1) {
                throw TwException.error("", "任务类别未配置状态流");
            }
            StateFlowVO stateFlowVO = page.getRecords().get(0);
            Assert.notNull(stateFlowVO, "关联状态流未配置状态");
            payload.setStateFlowId(stateFlowVO.getId());
            payload.setStateFlowName(stateFlowVO.getName());
            // 无用
            payload.setTaskStatus(TaskProStatusEnum.START.getCode());
        }


    }

    /**
     * 任务成员数据处理
     * 任务相关人数据处理
     *
     * @param fieldsUpdateLog
     * @param payload         有效载荷
     * @param taskId          任务id
     */
    private void taskMemberDataProcess(StringBuilder fieldsUpdateLog, TaskProPayload payload, Long taskId) {
        TaskMemberRefQuery memberRefQueryFollow = new TaskMemberRefQuery();
        memberRefQueryFollow.setType(TaskMemberRefTypeEnum.RELATED.getCode());
        memberRefQueryFollow.setObjType(TaskMemberRefObjTypeEnum.FOLLOW.getCode());
        memberRefQueryFollow.setTaskId(taskId);
        List<TaskMemberRefVO> followOldList = taskMemberRefService.queryListDynamic(memberRefQueryFollow);
        List<Long> followIdList1 = followOldList.stream().map(item -> item.getObjId()).collect(Collectors.toList());
        String followChange = "关注人";
        String followOldName = "";
        boolean followChangeFlag1 = false;
        if (CollectionUtils.isEmpty(followOldList)) {
            followChangeFlag1 = true;
        } else {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(followIdList1);
            List<ProRelatedPartiesVO> listSimple = proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            followOldName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
        }


        TaskMemberRefQuery memberRefQuery = new TaskMemberRefQuery();
        memberRefQuery.setType(TaskMemberRefTypeEnum.RELATED.getCode());
        memberRefQuery.setObjType(TaskMemberRefObjTypeEnum.PART.getCode());
        memberRefQuery.setTaskId(taskId);
        List<TaskMemberRefVO> partOldList = taskMemberRefService.queryListDynamic(memberRefQuery);
        List<Long> partIdList1 = partOldList.stream().map(item -> item.getObjId()).collect(Collectors.toList());
        String partChange = "参与人";
        String partOldName = "";
        boolean partChangeFlag1 = false;
        if (CollectionUtils.isEmpty(partOldList)) {
            partChangeFlag1 = true;
        } else {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(partIdList1);
            List<ProRelatedPartiesVO> listSimple = proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            partOldName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
        }
        // 团队成员清空
        taskMemberRefService.deleteSoftByTaskId(taskId);

        // 人员变更对比
        List<Long> memberFollowIdList = payload.getMemberFollowIdList();
        if (null == memberFollowIdList) {
            memberFollowIdList = new ArrayList<>();
        }
        List<Long> finalMemberFollowIdList = memberFollowIdList;
        List<Long> diffFollow = followIdList1.stream().filter(item -> !finalMemberFollowIdList.contains(item)).collect(Collectors.toList());
        List<Long> diffFollow1 = finalMemberFollowIdList.stream().filter(item -> !followIdList1.contains(item)).collect(Collectors.toList());
        diffFollow.addAll(diffFollow1);
        boolean followChangeFlag2 = false;
        // 团队成员插入数据
        if (!CollectionUtils.isEmpty(memberFollowIdList)) {
            memberFollowIdList.forEach(id -> {
                TaskMemberRefPayload memberRefPayload = new TaskMemberRefPayload();
                memberRefPayload.setType(TaskMemberRefTypeEnum.RELATED.getCode());
                memberRefPayload.setObjType(TaskMemberRefObjTypeEnum.FOLLOW.getCode());
                memberRefPayload.setObjId(id);
                memberRefPayload.setTaskId(taskId);
                taskMemberRefService.insert(memberRefPayload);
            });
        } else {
            // 人员清空了
            followChangeFlag2 = true;
        }
        if (!CollectionUtils.isEmpty(diffFollow)) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(finalMemberFollowIdList);
            List<ProRelatedPartiesVO> listSimple = proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            String changeFollowName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
            if (followChangeFlag1) {
                followChange = followChange + " 由 空 修改为 " + changeFollowName;
            } else if (followChangeFlag2) {
                followChange = followChange + " 由 " + followOldName + " 修改为 空";
            } else {
                followChange = followChange + " 由 " + followOldName + " 修改为 " + changeFollowName;
            }
            fieldsUpdateLog.append(followChange + "\n");
        }

        // 人员变更对比
        List<Long> memberPartIdList = payload.getMemberPartIdList();
        if (null == memberPartIdList) {
            memberPartIdList = new ArrayList<>();
        }
        List<Long> finalMemberPartIdList = memberPartIdList;
        List<Long> diffPart = partIdList1.stream().filter(item -> !finalMemberPartIdList.contains(item)).collect(Collectors.toList());
        List<Long> diffPart1 = memberPartIdList.stream().filter(item -> !partIdList1.contains(item)).collect(Collectors.toList());
        diffPart.addAll(diffPart1);
        // 团队成员插入数据
        boolean partChangeFlag2 = false;
        if (!CollectionUtils.isEmpty(memberPartIdList)) {
            memberPartIdList.forEach(id -> {
                TaskMemberRefPayload memberRefPayload = new TaskMemberRefPayload();
                memberRefPayload.setType(TaskMemberRefTypeEnum.RELATED.getCode());
                memberRefPayload.setObjType(TaskMemberRefObjTypeEnum.PART.getCode());
                memberRefPayload.setObjId(id);
                memberRefPayload.setTaskId(taskId);
                taskMemberRefService.insert(memberRefPayload);
            });
        } else {
            // 人员清空了
            partChangeFlag2 = true;
        }

        if (!CollectionUtils.isEmpty(diffPart)) {
            ProRelatedPartiesQuery proRelatedPartiesQuery = new ProRelatedPartiesQuery();
            proRelatedPartiesQuery.setIdList(finalMemberPartIdList);
            List<ProRelatedPartiesVO> listSimple = proRelatedPartiesService.getListSimple(proRelatedPartiesQuery);
            String changeName = listSimple.stream().map(ProRelatedPartiesVO::getName).collect(Collectors.joining(","));
            if (partChangeFlag1) {
                partChange = partChange + " 由 空 修改为 " + changeName;
            } else if (partChangeFlag2) {
                partChange = partChange + " 由 " + changeName + " 修改为 空";
            } else {
                partChange = partChange + " 由 " + partOldName + " 修改为 " + changeName;
            }
            fieldsUpdateLog.append(partChange + "\n");
        }


    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TaskProVO update(TaskProPayload payload) {
        TaskProDO entity = taskProRepo.findById(payload.getId()).orElseGet(TaskProDO::new);
        Assert.notNull(entity.getId(), "任务不存在");

        // 如果是活动任务
        Long wbsId = entity.getWbsId();
        if (wbsId != null) {
            // 查询活动状态
            PmsProjectWbsVO pmsProjectWbsVO = pmsProjectWbsService.queryByKey(wbsId);
            String wbsStatus = pmsProjectWbsVO.getWbsStatus();
            if (StringUtils.hasText(wbsStatus) && wbsStatus.equals(ProjectWbsStatusEnum.FINISHED.getCode())) {
                throw TwException.error("", "该任务归属的活动已完成，无法进行修改操作");
            }

            Long directorRelatedPartiesId = payload.getDirectorRelatedPartiesId();
            if (null == directorRelatedPartiesId) {
                directorRelatedPartiesId = entity.getDirectorRelatedPartiesId();
            }
            if (null == payload.getReasonId()) {
                payload.setReasonId(entity.getReasonId());
            }
            //  校验活动预算
            checkWbsBudget(payload, directorRelatedPartiesId, wbsId, pmsProjectWbsVO);

        }
        // 用于获取变更日志
        if (entity.getDirectorRelatedPartiesId() != null) {
            ProRelatedPartiesVO simple = proRelatedPartiesService.getSimple(entity.getDirectorRelatedPartiesId());
            entity.setDirectorRelatedPartiesName(simple.getName());
        }


        // 状态名称冗余处理
        Long stateFlowId = payload.getStateFlowId();
        if (null != stateFlowId) {
            StateFlowVO stateFlowVO = stateFlowService.get(stateFlowId);
            Assert.notNull(stateFlowVO, "状态不存在");
            // 冗余状态名称
            String stateFlowVOName = stateFlowVO.getName();
            payload.setStateFlowName(stateFlowVOName);
            // if(!stateFlowId.equals(entity.getStateFlowId())){
            //     StateFlowVO stateFlowVO = stateFlowService.get(stateFlowId);
            //     Assert.notNull(stateFlowVO, "状态不存在");
            //     // 状态变更了
            //     String stateFlowVOName = stateFlowVO.getName();
            //     String newStateFlowNameLog = " 状态 由 " + entity.getStateFlowName() + " 修改为 " + stateFlowVOName;
            //     payload.setStateFlowName(stateFlowVOName);
            // }
        }

        // 变更日志用
        TaskProDO entityLog = new TaskProDO();
        BeanUtils.copyProperties(entity, entityLog);

        TaskProDO entityDo = TaskProConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        // 字段 类型转换，方便记录操作日志
        if (entityDo.getActualWorkHoursChangeLog() != null) {
            entityDo.setActualWorkHoursChangeLog(entityDo.getActualWorkHoursChangeLog().intValue());
        }
        if (entityDo.getPredictWorkHoursChangeLog() != null) {
            entityDo.setPredictWorkHoursChangeLog(entityDo.getPredictWorkHoursChangeLog().intValue());
        }
        // 用于获取变更日志
        if (entityDo.getDirectorRelatedPartiesId() != null) {
            ProRelatedPartiesVO simple = proRelatedPartiesService.getSimple(payload.getDirectorRelatedPartiesId());
            entityDo.setDirectorRelatedPartiesName(simple.getName());
        }
        // 修改NULL值特殊处理
        final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
        TaskProDO save = taskProRepo.save(entity);
        Long taskId = save.getId();
        // 任务相关人数据处理
        taskMemberDataProcess(fieldsUpdateLog, payload, taskId);

        //获取变更日志
        fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));

        // 记录操作记录
        if (StringUtils.hasText(fieldsUpdateLog)) {
            logService.saveNewLog(entityDo.getId(), ComLogTypeEnum.PMS_TASK_PRO.getCode(), fieldsUpdateLog.toString());
        }
        if (save.getWbsId() != null) {
            // 基于活动的任务创建完成，触发活动清单状态 -> 开始
            TaskProEventFactory.SERVICE_MAP.forEach((taskProEventEnum, taskProEventService) -> {
                taskProEventService.taskCreateOk(save);
                // if (taskProEventEnum.equals(TaskProEventEnum.WBS_ACT_LIST)) {
                //     TaskProEventFactory.SERVICE_MAP.get(TaskProEventEnum.WBS_ACT_LIST).taskCreateOk(save);
                // }
            });
        }
        return TaskProConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TaskProPayload payload) {
        TaskProDO entity = taskProRepo.findById(payload.getId()).orElseGet(TaskProDO::new);
        Assert.notNull(entity.getId(), "任务不存在");
        long result = taskProDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            taskProDAO.deleteSoft(keys);
            // 任务删除时，占用的预算成本需要进行释放

        }
    }

    @Override
    public long top(TaskProPayload payload) {
        if (payload.getTopFlag() != null) {
            TaskProDO entity = taskProRepo.findById(payload.getId()).orElseGet(TaskProDO::new);
            Assert.notNull(entity.getId(), "任务不存在");
            String logMsg = "";
            if (payload.getTopFlag()) {
                entity.setTopModifyTime(LocalDateTime.now());
                logMsg = "置顶";
            } else {
                entity.setTopModifyTime(null);
                logMsg = "取消置顶";
            }
            entity.setTopFlag(payload.getTopFlag());
            entity.setTopModifyTime(LocalDateTime.now());
            taskProRepo.save(entity);
            logService.saveNewLog(entity.getId(), ComLogTypeEnum.PMS_TASK_PRO.getCode(), logMsg);
        }
        return 0;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean updatePartiesId(List<TaskProQuery> taskProQueryList) {

        taskProQueryList.forEach(x -> {
            TaskProPayload taskProPayload = new TaskProPayload();
            taskProPayload.setId(x.getId());
            taskProPayload.setDirectorRelatedPartiesId(x.getDirectorRelatedPartiesId());
            taskProDAO.updateByKeyDynamic(taskProPayload);
        });

        return null;
    }

    @Override
    public TaskProVO createSub(TaskProPayload payload) {
        Long parentId = payload.getParentId();
        Assert.notNull(parentId, "父任务id[parentId]不能为空");
        Assert.hasText(payload.getTaskName(), "任务标题不能为空");


        TaskProVO taskProParentVO = queryByKey(parentId);


        // 接收一个子任务名称
        TaskProPayload subTaskPayload = new TaskProPayload();
        // 父任务
        subTaskPayload.setParentId(parentId);
        //
        subTaskPayload.setTaskName(payload.getTaskName());
        // 优先级
        subTaskPayload.setPriority(TaskProPriorityEnum.LOW.getCode());
        // 拷贝父任务的信息
        //类别
        subTaskPayload.setTaskCategoryId(taskProParentVO.getTaskCategoryId());
        // 负责人(相关方)
        subTaskPayload.setDirectorRelatedPartiesId(taskProParentVO.getDirectorRelatedPartiesId());
        subTaskPayload.setPlanStartDate(taskProParentVO.getPlanStartDate());
        subTaskPayload.setPlanEndDate(taskProParentVO.getPlanEndDate());

        subTaskPayload.setReasonId(taskProParentVO.getReasonId());
        subTaskPayload.setReasonType(taskProParentVO.getReasonType());
        subTaskPayload.setShowScope(taskProParentVO.getShowScope());
        subTaskPayload.setWbsId(taskProParentVO.getWbsId());
        subTaskPayload.setWbsName(taskProParentVO.getWbsName());
        subTaskPayload.setPredictWorkHours(taskProParentVO.getPredictWorkHours());

        // 创建子任务
        return insert(subTaskPayload);
    }

    @Override
    public List<TaskProBoardViewGroupInfoVO> boardViewGroup(TaskProQuery query) {
        /**
         *   - 个人：我创建的、我负责的、我关注的、我参与的
         *   - 全部：个人+他人创建的任务（公开）
         */
        List<TaskProBoardViewGroupInfoVO> list = new ArrayList<>();

        Long loginUserId = GlobalUtil.getLoginUserId();


        // 我负责的
        long myDirectorCount = 0l;
        long myPartCount = 0l;
        long myFollowCount = 0l;
        long myAllCount = 0l;
        long myCreateCount = 0l;
        Long reasonId = query.getReasonId();
        String reasonType = query.getReasonType();
        Long taskCategoryId = query.getTaskCategoryId();
        if (
                (!ObjectUtils.isEmpty(reasonType) && reasonType.equals(TaskReasonTypeEnum.PROJ_CONTRACT.getCode()))
                        && reasonId != null
            // && taskCategoryId != null
        ) {
            // 根据项目id、当前登录人、获取其相对方的主键  并统计相应任务个数
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                TaskProQuery taskProDirectorQuery = new TaskProQuery();
                BeanUtils.copyProperties(query, taskProDirectorQuery);
                taskProDirectorQuery.setDirectorRelatedPartiesId(relatedPartiesVOId);
                myDirectorCount = taskProDAO.count(taskProDirectorQuery);

                // 我参与的
                myPartCount = taskProDAO.countLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.PART.getCode());
                // 我关注的
                myFollowCount = taskProDAO.countLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.FOLLOW.getCode());
                // 我创建的
                TaskProQuery taskProQuery = new TaskProQuery();
                BeanUtils.copyProperties(query, taskProQuery);
                taskProQuery.setCreateRelatedPartiesId(relatedPartiesVOId);
                myCreateCount = taskProDAO.count(taskProQuery);
            }

            TaskProQuery taskAllProQuery = new TaskProQuery();
            BeanUtils.copyProperties(query, taskAllProQuery);
            taskAllProQuery.setSearchType(TaskProGroupEnum.ALL_ALL.getCode());
            // 根据项目id、当前登录人、获取其相对方的主键  并统计相应任务个数
            List<ProRelatedPartiesVO> listAllSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            Set<Long> relatedIdList = listAllSimple.stream().map(ProRelatedPartiesVO::getId).collect(Collectors.toSet());
            taskAllProQuery.setRelatedIdList(relatedIdList);
            if (CollectionUtils.isEmpty(relatedIdList)) {
                relatedIdList.add(9999L);
                taskAllProQuery.setRelatedIdList(relatedIdList);
            }
            taskAllProQuery.setReasonId(reasonId);
            taskAllProQuery.setTaskCategoryId(taskCategoryId);
            myAllCount = taskProDAO.count(taskAllProQuery);


        } else {
            // 我创建的
            TaskProQuery taskProQuery = new TaskProQuery();
            BeanUtils.copyProperties(query, taskProQuery);
            taskProQuery.setCreateUserId(loginUserId);
            myCreateCount = taskProDAO.count(taskProQuery);
        }
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.ALL_ALL.getType(), TaskProGroupEnum.ALL_ALL.getCode(), TaskProGroupEnum.ALL_ALL.getDesc(), myAllCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_CREATE.getType(), TaskProGroupEnum.MY_CREATE.getCode(), TaskProGroupEnum.MY_CREATE.getDesc(), myCreateCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_DIRECTOR.getType(), TaskProGroupEnum.MY_DIRECTOR.getCode(), TaskProGroupEnum.MY_DIRECTOR.getDesc(), myDirectorCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_PART.getType(), TaskProGroupEnum.MY_PART.getCode(), TaskProGroupEnum.MY_PART.getDesc(), myPartCount));
        list.add(new TaskProBoardViewGroupInfoVO(TaskProGroupEnum.MY_FOLLOW.getType(), TaskProGroupEnum.MY_FOLLOW.getCode(), TaskProGroupEnum.MY_FOLLOW.getDesc(), myFollowCount));
        return list;
    }

    @Override
    public List<TaskProBoardVO> boardView(TaskProQuery query) {
        List<TaskProBoardVO> resultList = new ArrayList<>();
        // 传入类别id
        Long taskCategoryId = query.getTaskCategoryId();

        if (null != taskCategoryId) {
            StateFlowQuery stateFlowQuery = new StateFlowQuery();

            stateFlowQuery.setObjId(taskCategoryId);
            OrderItem orderItem = OrderItem.desc("sort");
            OrderItem orderItem2 = OrderItem.asc("createTime");
            List<OrderItem> orderItemList = new ArrayList<>();
            orderItemList.add(orderItem);
            orderItemList.add(orderItem2);
            stateFlowQuery.setOrders(orderItemList);
            List<StateFlowVO> stateFlowVOList = stateFlowService.getList(stateFlowQuery);
            String searchType = query.getSearchType();
            if (ObjectUtils.isEmpty(searchType)) {
                searchType = TaskProGroupEnum.ALL_ALL.getCode();
            }
            String finalSearchType = searchType;
            stateFlowVOList.forEach(stateFlowVO -> {
                TaskProBoardVO taskProBoardVO = new TaskProBoardVO();
                taskProBoardVO.setName(stateFlowVO.getName());
                taskProBoardVO.setState(stateFlowVO.getState());
                taskProBoardVO.setStateFlowId(stateFlowVO.getId());
                taskProBoardVO.setBackgroundColor(stateFlowVO.getBackgroundColor());
                taskProBoardVO.setFontColor(stateFlowVO.getFontColor());

                // 查询状态流下的任务
                query.setStateFlowId(stateFlowVO.getId());
                List<OrderItem> taskOrderItemList = new ArrayList<>();
                taskOrderItemList.add(OrderItem.desc("topFlag"));
                taskOrderItemList.add(OrderItem.desc("topModifyTime"));
                taskOrderItemList.add(OrderItem.desc("sort"));
                taskOrderItemList.add(OrderItem.desc("createTime"));
                query.setOrders(taskOrderItemList);


                // 获取任务数据
                List<TaskProVO> taskProVOS = getTaskProVOS(query, finalSearchType);
                // 子任务数量
//                taskProVOS.forEach(taskProVO -> {
//                    TaskProQuery childTaskProQuery = new TaskProQuery();
//                    childTaskProQuery.setParentId(taskProVO.getId());
//                    long count = taskProDAO.count(childTaskProQuery);
//                    taskProVO.setChildCount(count);
//                });
//                taskProBoardVO.setTaskList(taskProVOS);
                resultList.add(taskProBoardVO);
            });

        }
        return resultList;
    }

    /**
     * 子任务父任务解绑
     *
     * @param subTaskId    子任务id
     * @param parentTaskId 父任务id
     * @return {@link Boolean}
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean unbindRef(Long subTaskId, Long parentTaskId) {
        long count = taskProDAO.unbindRef(subTaskId, parentTaskId);
        return count > 0;
    }

    @Override
    public List<TaskProVO> queryListDynamicForExcelExport(TaskProQuery query) {

        String finalSearchType = query.getSearchType();
        if (ObjectUtils.isEmpty(finalSearchType)) {
            finalSearchType = TaskProGroupEnum.ALL_ALL.getCode();
        }
        List<TaskProVO> taskProVOS = getTaskProVOS(query, finalSearchType);
        return taskProVOS;
    }

    @Override
    @Transactional
    public Boolean updateBatch(List<TaskProPayload> payloadList) {
        for (TaskProPayload taskProPayload : payloadList) {
            this.updateByKeyDynamic(taskProPayload);
        }
        return true;
    }

    @Override
    public BigDecimal summaryWbs(Long wbsId, String type) {
        BigDecimal resSum = BigDecimal.ZERO;
        if ("ACT".equals(type)) {
            TaskProQuery taskProQuery = new TaskProQuery();
            taskProQuery.setWbsId(wbsId);
            List<TaskProVO> taskProVOS = queryListDynamic(taskProQuery);
            // 所有任务下的预估工时
            BigDecimal sumTaskHours = taskProVOS.stream().filter(x -> null != x.getPredictWorkHours()).map(x -> x.getPredictWorkHours()).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (BigDecimal.ZERO.compareTo(sumTaskHours) == 0) {
                return BigDecimal.ZERO;
            }
            for (TaskProVO taskProVO : taskProVOS) {
                // 预估工时为空则不处理
                if (null == taskProVO.getPredictWorkHours()) {
                    continue;
                }
                StateFlowVO stateFlowVO = stateFlowService.get(taskProVO.getStateFlowId());
                BigDecimal bigDecimal = taskProVO.getPredictWorkHours().divide(sumTaskHours,2, BigDecimal.ROUND_HALF_UP);
                BigDecimal multiply = stateFlowVO.getProgressPercentage().multiply(bigDecimal);
                resSum = resSum.add(multiply);
            }
        }
        return resSum;
    }

    @Override
    public List<TaskProVO> queryListByTaskIdsAndHaveWbsId(List<Long> taskIds) {
        return taskProDAO.queryListByTaskIdsAndHaveWbsId(taskIds);
    }

    private List<TaskProVO> getTaskProVOS(TaskProQuery query, String finalSearchType) {
        List<TaskProVO> taskProVOS = new ArrayList<>();
        Long reasonId = query.getReasonId();
        if (finalSearchType.equals(TaskProGroupEnum.ALL_ALL.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            // 根据当前登录人、获取其相对方的主键
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            Set<Long> relatedIdList = listSimple.stream().map(ProRelatedPartiesVO::getId).collect(Collectors.toSet());
            query.setRelatedIdList(relatedIdList);
            if (CollectionUtils.isEmpty(query.getRelatedIdList())) {
                relatedIdList.add(9999L);
                query.setRelatedIdList(relatedIdList);
            }
            taskProVOS = queryListDynamic(query);
            // 我创建的
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_CREATE.getCode())) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            // 项目维度下
            if (null != reasonId) {
                // 根据当前登录人、获取其相对方的主键
                List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
                if (!CollectionUtils.isEmpty(listSimple)) {
                    ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                    Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                    query.setCreateRelatedPartiesId(relatedPartiesVOId);
                    taskProVOS = queryListDynamic(query);
                }
            } else {
                query.setCreateUserId(loginUserId);
                taskProVOS = queryListDynamic(query);
            }
            // 我负责的
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_DIRECTOR.getCode())) {
            Assert.notNull(reasonId, "请选择项目，参数缺失");
            Long loginUserId = GlobalUtil.getLoginUserId();
            // 根据项目id、当前登录人、获取其相对方的主键  并统计相应任务个数
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                query.setDirectorRelatedPartiesId(relatedPartiesVOId);
                taskProVOS = queryListDynamic(query);
            }
            // 我关注的
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_FOLLOW.getCode())) {
            Assert.notNull(reasonId, "请选择项目，参数缺失");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                // 我关注的
                taskProVOS = taskProDAO.queryListDynamicLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.FOLLOW.getCode());
            }
            // 我参与的
        } else if (finalSearchType.equals(TaskProGroupEnum.MY_PART.getCode())) {
            Assert.notNull(reasonId, "请选择项目，参数缺失");
            Long loginUserId = GlobalUtil.getLoginUserId();
            List<ProRelatedPartiesVO> listSimple = getProRelatedPartiesVOS(reasonId, loginUserId);
            if (!CollectionUtils.isEmpty(listSimple)) {
                ProRelatedPartiesVO proRelatedPartiesVO = listSimple.get(0);
                Long relatedPartiesVOId = proRelatedPartiesVO.getId();

                // 我参与的
                taskProVOS = taskProDAO.queryListDynamicLeftJoinMemberRef(query, relatedPartiesVOId, TaskMemberRefObjTypeEnum.PART.getCode());
            }
        } else {
            taskProVOS = queryListDynamic(query);
        }
        return taskProVOS;
    }

}
