package com.elitesland.tw.tw5.server.prd.taskpro.support;

import com.elitesland.tw.tw5.server.prd.taskpro.constants.TaskProEventEnum;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;

/**
 * 任务事件服务 工厂
 *
 * @author duwh
 * @date 2023/12/11
 */
@Slf4j
public class TaskProEventFactory {

    /**
     * 容器
     */
    public static final HashMap<Object, TaskProEventService> SERVICE_MAP = new HashMap<>();


    /**
     * 注册到容器中
     *
     * @param taskProEventEnum 文档类型引用枚举
     * @param service          服务
     */
    public void register(TaskProEventEnum taskProEventEnum, TaskProEventService service) {
        if (null == taskProEventEnum) {
            log.error("taskProEventEnum not exit");
            throw new RuntimeException("taskProEventEnum not exit");
        }
        SERVICE_MAP.put(taskProEventEnum.getCode(), service);
    }


    public static class Holder {
        private static TaskProEventFactory instance = new TaskProEventFactory();
    }

    public static TaskProEventFactory getInstance() {
        return Holder.instance;
    }


}
