package com.elitesland.tw.tw5.server.prd.ts.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ts.payload.TsApprovalResPayload;
import com.elitesland.tw.tw5.api.prd.ts.query.TsApprovalResQuery;
import com.elitesland.tw.tw5.api.prd.ts.service.TsApprovalResService;
import com.elitesland.tw.tw5.api.prd.ts.vo.TsApprovalResVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 工时审批资源管理
 *
 * @author carl
 * @date 2024-05-04
 */
@Api(tags = "工时审批资源管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/ts/tsApprovalRes")
@Slf4j
public class TsApprovalResController {

    private final TsApprovalResService tsApprovalResService;

    /**
     * 工时审批资源管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("工时审批资源管理-新增")
    public TwOutputUtil<TsApprovalResVO> insert(@RequestBody TsApprovalResPayload payload) {
        return TwOutputUtil.ok(tsApprovalResService.insert(payload));
    }

    /**
     * 工时审批资源管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("工时审批资源管理-更新")
    public TwOutputUtil<TsApprovalResVO> update(@RequestBody TsApprovalResPayload payload) {
        return TwOutputUtil.ok(tsApprovalResService.update(payload));
    }

    /**
     * 工时审批资源管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("工时审批资源管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TsApprovalResPayload payload) {
        return TwOutputUtil.ok(tsApprovalResService.updateByKeyDynamic(payload));
    }

    /**
     * 工时审批资源管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("工时审批资源管理-主键查询")
    public TwOutputUtil<TsApprovalResVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tsApprovalResService.queryByKey(key));
    }

    /**
     * 工时审批资源管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("工时审批资源管理-分页")
    public TwOutputUtil<PagingVO<TsApprovalResVO>> paging(TsApprovalResQuery query) {
        return TwOutputUtil.ok(tsApprovalResService.queryPaging(query));
    }

    /**
     * 工时审批资源管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("工时审批资源管理-查询列表")
    public TwOutputUtil<List<TsApprovalResVO>> queryList(TsApprovalResQuery query) {
        return TwOutputUtil.ok(tsApprovalResService.queryListDynamic(query));
    }

    /**
     * 工时审批资源管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("工时审批资源管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        tsApprovalResService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

