package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityOutCostService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityOutCostDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/**
 * @author yangzhibin
 * @date 2022/12/16
 */
@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "OPPO_OUT_COST" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class OppoOutCostWorkflowCallBackController implements WorkflowCallBack {

    private final CrmOpportunityOutCostService opportunityOutCostService;
    private final CrmOpportunityOutCostDAO opportunityOutCostDAO;
    private final HttpUtil httpUtil;
    private final TransferUtilServiceImpl transferUtilService;
    @Value("${tw4.opportunity.outCost_operation}")
    private String outCost_operation;

    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("动态指定任务负责人参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务创建回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     *
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     *
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CrmOpportunityOutCostPayload outCostPayload = new CrmOpportunityOutCostPayload();
        final long id = Long.parseLong(businessKey);
        outCostPayload.setId(id);
        //根据业务key查询当前业务对象
        final CrmOpportunityOutCostVO crmOpportunityOutCostVO = opportunityOutCostService.queryById(id);
        if (crmOpportunityOutCostVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    outCostPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    outCostPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    outCostPayload.setProcInstStatus(ProcInstStatus.INTERRUPT);
                    break;
                case INVALID://先删除流程再删除单据
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setDeleteFlag(1);
                    outCostPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.INVALID.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.INVALID.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    outCostPayload.setActivataStatus("0");
                    crmOpportunityOutCostVO.setActivataStatus("0");
                    outCostPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
                    outCostPayload.setApprovedTime(LocalDateTime.now());

                    //同步到4.0
//                    Long outCostIdV4 = opportunityOutCostDAO.queryTW4IdById(crmOpportunityOutCostVO.getId());
//                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
//                    crmOpportunityOutCostVO.setProcInstStatus(ProcInstStatus.APPROVED);
//                    Map<String, Object> map = transferUtilService.beanToMap(crmOpportunityOutCostVO);
//                    map.put("id", outCostIdV4);
//                    String result = httpUtil.sendSyncPost(outCost_operation, map);
//                    String outCostId = httpUtil.geResultData(result);
//                    if (StringUtils.hasText(outCostId)) {
//                        if (StringUtil.isInteger(outCostId)) {
//                            outCostIdV4 = Long.valueOf(outCostId);
//                        }
//                    }
//                    outCostPayload.setOutCostIdV4(outCostIdV4);
                    break;
                case APPROVING:
                    outCostPayload.setActivataStatus("1");
                    outCostPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            }
            opportunityOutCostDAO.updateByKeyDynamic(outCostPayload);
        }
        return WorkflowResult.success(null);
    }

}
