package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.purchase.payload.TPurchaseContractOverPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.TPurchaseContractOverService;
import com.elitesland.tw.tw5.api.prd.purchase.vo.TPurchaseContractOverVO;
import com.elitesland.tw.tw5.server.prd.purchase.dao.PurchaseContractManagerDAO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchaseContractStatusEnum;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

@Slf4j
@RestController
@RequestMapping(WorkflowConstant.WORKFLOW + "PUR_CON_OVER" + WorkflowConstant.CALLBACK)
@Transactional
@RequiredArgsConstructor
public class PurchaseContractOverCallBackController implements WorkflowCallBack {

    private final TPurchaseContractOverService service;
    private final PurchaseContractManagerDAO purchaseContractManagerDAO;


    /**
     * 动态指定任务负责人
     *
     * @return 任务负责人ID列表
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_ASSIGNEE_PATH)
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    /**
     * 任务创建回调
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_CREATED_PATH)
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("任务创建后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 任务完成回调(只有正常推下一个节点,才算任务完成,其他从当前任务撤回/驳回都能不算当前任务完成,不会触发下面回调)
     */
    @Override
    @PostMapping(WorkflowConstant.TASK_COMPLETED_PATH)
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("任务完成后回调参数: {}", payload);
        return WorkflowResult.success(null);
    }

    /**
     * 流程状态变化回调
     */
    @Override
    @PostMapping(WorkflowConstant.PROCESS_STATUS_CHANGE_PATH)
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("流程状态变化回调参数:{}", payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TPurchaseContractOverPayload purchaseContractOverPayload = new TPurchaseContractOverPayload();
        purchaseContractOverPayload.setId(Long.parseLong(businessKey));
        //根据业务key查询当前业务对象
        TPurchaseContractOverVO tPurchaseContractOverVO = service.queryByKey(Long.valueOf(businessKey));
        Long purchaseContractId = tPurchaseContractOverVO.getContractId();
        if (tPurchaseContractOverVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //一般情况将单据状态变成"新建",流程状态改为未提交
//                    tPurchaseContractOverVO.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
//                    epibolyCostConDPayload.setDetailedStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    purchaseContractOverPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));

                    // 修改合同状态
                    purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.ACTIVE.getCode());
                    break;
                case INVALID://先删除流程再删除单据
                    purchaseContractOverPayload.setDeleteFlag(1);
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    // 修改合同状态
                    purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.ACTIVE.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.CREATE.getCode());
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                case APPROVED:
                    //一般情况将单据状态变成"激活"
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    purchaseContractOverPayload.setApprovedTime(LocalDateTime.now());
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.NOT_ACTIVE.getCode());
                    // 修改合同状态
                    purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.BREAK.getCode());
                    break;
                case APPROVING:
                    purchaseContractOverPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    purchaseContractOverPayload.setOverStatus(PurchaseContractStatusEnum.APPROVING.getCode());
                    // 修改合同状态
                    purchaseContractManagerDAO.updateStatusByKeys(Collections.singletonList(purchaseContractId), PurchaseContractStatusEnum.APPROVING.getCode());
                    break;
            }
            service.updateByKeyDynamic(purchaseContractOverPayload);
        }
        return WorkflowResult.success(null);
    }
}
