package com.elitesland.tw.tw5.server.yeedocpro.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.pms.payload.NewUploadFilesSavePayload;
import com.elitesland.tw.tw5.api.yeedocpro.vo.ItemInfoDataFileDTO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.log.service.ApiRequestLogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.yeedocpro.config.YeedocProProperties;
import com.elitesland.tw.tw5.server.yeedocpro.dto.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

import java.nio.charset.StandardCharsets;
import java.util.*;

/**
 * yeedoc服务
 *
 * @author
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class YeedocProServiceImpl implements YeedocProService {

    private final ApiRequestLogService apiRequestLogService;
    /**
     * yeedoc属性配置
     */
    private final YeedocProProperties yeedocProperties;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;

    /**
     * 保存新上传文件
     *
     *
     * 解决重名覆盖的方法：
     * {
     *     "ItemList": [
     *         {
     *             "CacheKey": "Ptcent_YiDoc_Item_WebApi_TempLoadFile82e2f240-db2d-47ec-ba9f-ada01e29db4a",
     *             "Id": "c4eaa5ad-c50a-44f2-abee-b5dcaa4a6307",
     *             "OperationType": 1
     *         }
     *     ],
     *     "CacheKey": [
     *         "Ptcent_YiDoc_Item_WebApi_TempLoadFile82e2f240-db2d-47ec-ba9f-ada01e29db4a"
     *     ],
     *     "LibraryId": "d5d26f53-81a2-46e9-991c-4321a53a7516",
     *     "FolderId": "3b746706-4d41-4707-9a38-6ca90c086c93",
     *     "AssociatedItemID": [
     *
     *     ],
     *     "Description": ""
     * }
     *
     * @param payload 有效载荷
     * @return {@link List}<{@link String}>
     */
    @Override
    public List<String> newUploadFilesSave(NewUploadFilesSavePayload payload) {
        Assert.notNull(payload.getLibraryId(), "库ID不能为空");
        Assert.notNull(payload.getFolderId(), "文件夹ID不能为空");
        Assert.notEmpty(payload.getCacheKey(), "附件ID不能为空");
        String yeedocJwt = getYeedocJwt();
        String newUploadFilesSaveUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/NewUploadFilesSave";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(payload), Map.class);
        String result = executePost(newUploadFilesSaveUrl, map, yeedocJwt);
        if (StringUtils.isEmpty(result)) {
            log.info("[最终保存文件-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        NewUploadFilesSaveDTO resultDTO;
        try {
            resultDTO = JSONObject.parseObject(result, NewUploadFilesSaveDTO.class);
        } catch (Exception e) {
            log.error("[最终保存文件-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        if (resultDTO.getCode() == 0) {
            /**
             * https://yeedoctw-uat.tw-test.elitesland.com/itemapi/Item/NewUploadFilesSave
             *
             * {"cacheKey":["Ptcent_YiDoc_Item_WebApi_TempLoadFile5557ac18-cbfa-4908-852d-312a80734414"],"libraryId":"d5d26f53-81a2-46e9-991c-4321a53a7516","folderId":"0640b0a0-8675-4b74-a1a4-f0985f2d2526"}
             *
             * {"Message":"存在同名文件或文件夹！","IsSuccess":true,"Code":0,"TotalCount":0,"Data":[{"CacheKey":"Ptcent_YiDoc_Item_WebApi_TempLoadFile5557ac18-cbfa-4908-852d-312a80734414","Id":"8dd91c07-e89d-474e-962f-08dd421829f8","Name":"mmexport1619363803627.jpg"}]}
             */
            if (org.springframework.util.StringUtils.hasText(resultDTO.getMessage()) && resultDTO.getMessage().equals("存在同名文件或文件夹！")) {
                throw TwException.error("", resultDTO.getMessage());
            }
            return resultDTO.getData();
        } else {
            log.error("[最终保存文件-易道壳]-resultStr:{}", result);
            throw TwException.error("", resultDTO.getMessage());
        }
    }

    @Override
    public List<GetCaCheKeyItemIdDTO> newUploadFilesSaveAndReturnItemId(NewUploadFilesSavePayload payload) {
        // 真实保存文件
        newUploadFilesSave(payload);
        // 获取上传的附件Id
        GetCaCheKeyItemIdPayload getCaCheKeyItemIdPayload = new GetCaCheKeyItemIdPayload();
        getCaCheKeyItemIdPayload.setCacheKeys(payload.getCacheKey());
        List<GetCaCheKeyItemIdDTO> caCheKeyItemId = getCaCheKeyItemId(getCaCheKeyItemIdPayload);
        return caCheKeyItemId;
    }

    @Override
    public List<GetCaCheKeyItemIdDTO> getCaCheKeyItemId(GetCaCheKeyItemIdPayload paload) {
        Assert.notNull(paload.getCacheKeys(), "附件ID不能为空");
        String yeedocJwt = getYeedocJwt();
        String getCaCheKeyItemIdUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetCaCheKeyItemId";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(paload), Map.class);
        String result = executePost(getCaCheKeyItemIdUrl, map, yeedocJwt);
        if (StringUtils.isEmpty(result)) {
            log.info("[getCaCheKeyItemId-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        GetCaCheKeyItemIdListDTO resultDTO;
        try {
            resultDTO = JSONObject.parseObject(result, GetCaCheKeyItemIdListDTO.class);
        } catch (Exception e) {
            log.error("[getCaCheKeyItemId-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        if (resultDTO.getCode() == 0) {
            return resultDTO.getData();
        } else {
            log.error("[getCaCheKeyItemId-易道壳]-resultStr:{}", result);
            throw TwException.error("", resultDTO.getMessage());
        }
    }

    @Override
    public List<GetAllItemsInfoDTO> getAllItemsInfo(GetAllItemsInfoPayload payload) {
        String yeedocJwt = getYeedocJwt();
        String uri = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetAllItemsInfo";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(payload), Map.class);
        String result = executePost(uri, map, yeedocJwt);
        if (StringUtils.isEmpty(result)) {
            log.info("[GetAllItemsInfo-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        GetAllItemsInfoListDTO resultDTO;
        try {
            resultDTO = JSONObject.parseObject(result, GetAllItemsInfoListDTO.class);
        } catch (Exception e) {
            log.error("[GetAllItemsInfo-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        if (resultDTO.getCode() == 0) {
            return resultDTO.getData();
        } else {
            log.error("[GetAllItemsInfo-易道壳]-resultStr:{}", result);
            throw TwException.error("", resultDTO.getMessage());
        }
    }

    @Override
    public YeedocCreateFolderForTwDTO createFolderForTw(CreateFolderTwPayload createFolderTwPayload) {
        String yeedocJwt = getYeedocJwt();
        String createFolderUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/CreatrFolderForTw";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(createFolderTwPayload), Map.class);
        String result = executePost(createFolderUrl, map, yeedocJwt);
        YeedocCreateFolderForTwDTO folderForTwReturnOne = createFolderForTwReturnOne(result);
        return folderForTwReturnOne;
    }

    @Override
    public YeedocCreateFolderForTwDTO createFolderForTwReturnOne(String yeedcocReturnResult) {
        if (StringUtils.isEmpty(yeedcocReturnResult)) {
            throw TwException.error("", "创建文件夹失败!result = {" + yeedcocReturnResult + "}");
        }
        YeedocCreateFolderForTwListDTO yeedocCreateFolderForTwListDTO = JSONObject.parseObject(yeedcocReturnResult, YeedocCreateFolderForTwListDTO.class);

        List<YeedocCreateFolderForTwDTO> dataList = yeedocCreateFolderForTwListDTO.getData();
        if (CollectionUtils.isEmpty(dataList)) {
            throw TwException.error("", "创建文件夹失败!result = {" + yeedcocReturnResult + "}");
        } else {
            return dataList.get(0);
        }
    }

    @Override
    public String createFolder(CreateFolderPayload createFolderPayload) {
        String yeedocJwt = getYeedocJwt();
        String createFolderUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/CreateFloder";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(createFolderPayload), Map.class);
        //!!!! 注释put请求
        return executePut(createFolderUrl, map, yeedocJwt);
    }

    @Override
    public YeedocCreateFolderDataDTO createFolderReturn(String yeedcocReturnResult) {
        if (StringUtils.isEmpty(yeedcocReturnResult)) {
            log.info("[创建文件夹-易道壳]-resultStr:{}", yeedcocReturnResult);
            throw TwException.error("", "创建文件夹失败：" + yeedcocReturnResult);
        }
        YeedocCreateFolderDTO createFolderDTO = null;
        try {
            createFolderDTO = JSONObject.parseObject(yeedcocReturnResult, YeedocCreateFolderDTO.class);
        } catch (Exception e) {
            log.error("[创建文件夹-易道壳]-resultStr:{}", yeedcocReturnResult);
            throw TwException.error("", "创建文件夹失败：" + yeedcocReturnResult);
        }
        if (createFolderDTO.getCode() == 0) {
            YeedocCreateFolderDataDTO data = createFolderDTO.getData();
            if (null == data) {
                log.error("[创建文件夹-易道壳]-resultStr:{}", yeedcocReturnResult);
                throw TwException.error("", createFolderDTO.getMessage());
            }
            return data;
        } else {
            log.error("[创建文件夹-易道壳]-resultStr:{}", yeedcocReturnResult);
            throw TwException.error("", createFolderDTO.getMessage());
        }

    }

    @Override
    public String itemInfo(ItemInfoPayload itemInfoPayload) {
        String yeedocJwt = getYeedocJwt();
        String uri = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/PMSItemInfo";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(itemInfoPayload), Map.class);
        return executePost(uri, map, yeedocJwt);
    }

    @Override
    public Map<String, List<ItemInfoDataFileDTO>> itemInfoReturn(ItemInfoPayload itemInfoPayload) {
        String yeedocJwt = getYeedocJwt();
        String uri = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/PMSItemInfo";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(itemInfoPayload), Map.class);
        String result = executePost(uri, map, yeedocJwt);
        if (StringUtils.isEmpty(result)) {
            log.error("[根据文件夹id批量查询其下文件-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        ItemInfoDataDTO infoDataDTO = null;
        try {
            infoDataDTO = JSONObject.parseObject(result, ItemInfoDataDTO.class);
        } catch (Exception e) {
            log.error("[根据文件夹id批量查询其下文件-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        if (infoDataDTO.getCode() == 0) {
            return infoDataDTO.getData();
        } else {
            log.error("[根据文件夹id批量查询其下文件-易道壳]-resultStr:{}", result);
            throw TwException.error("", infoDataDTO.getMessage());
        }
    }

    @Override
    public List<FolderListByItemNameDTO> folderListByItemName(FolderListByItemNamePayload payload) {
        String yeedocJwt = getYeedocJwt();
        String uri = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Template/FolderListByItemName";
        Map<String, Object> map = JSONObject.parseObject(JSONObject.toJSONString(payload), Map.class);
        String result = executePost(uri, map, yeedocJwt);
        if (StringUtils.isEmpty(result)) {
            log.error("[根据文件名称 查询 所属文件夹 id-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        FolderListByItemNameListDTO infoDataDTO = null;
        try {
            infoDataDTO = JSONObject.parseObject(result, FolderListByItemNameListDTO.class);
        } catch (Exception e) {
            log.error("[根据文件名称 查询 所属文件夹 id-易道壳]-resultStr:{}", result);
            throw TwException.error("", "创建文件夹失败：" + result);
        }
        if (infoDataDTO.getCode() == 0) {
            return infoDataDTO.getData();
        } else {
            log.error("[根据文件名称 查询 所属文件夹 id-易道壳]-resultStr:{}", result);
            throw TwException.error("", infoDataDTO.getMessage());
        }
    }


    // @Override
    // public String reNameFolder(Map<String, Object> map, String authToken) {
    //     String reNameFolderUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/ReName";
    //     log.info("[易道壳]-createFolderUrl:{}",reNameFolderUrl);
    //     return executePost(reNameFolderUrl, map, authToken);
    // }

    @Override
    public String reNameFolder(Map<String, Object> map) {
        String yeedocJwt = getYeedocJwt();
        String reNameFolderUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ReName";
        return executePost(reNameFolderUrl, map, yeedocJwt);
    }

    // @Override
    // public String newUploadFilesSave(Map<String, Object> map, String authToken) {
    //     String newUploadFilesSaveUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/NewUploadFilesSave";
    //     log.info("[易道壳]-newUploadFilesSave:{}",newUploadFilesSaveUrl);
    //     return executePost(newUploadFilesSaveUrl, map, authToken);
    // }

    // @Override
    // public String getCaCheKeyItemId(Map<String, Object> map, String authToken) {
    //     String getCaCheKeyItemIdUrl = yeedocProperties.getYeeDocLinkUrl()+"/itemapi/Item/GetCaCheKeyItemId";
    //     log.info("[易道壳]-getCaCheKeyItemId:{}",getCaCheKeyItemIdUrl);
    //     return executePost(getCaCheKeyItemIdUrl, map, authToken);
    // }


    /**
     * 获取item文件夹链接
     * 在易道壳返回浏览链接
     *
     * @param itemId
     */
    // @Override
    // public String preViewItem(String itemId) {
    //     //1. 获取token
    //     String token = getToken();
    //     //2. 加密
    //     String externalToken = base64Encrypt(token);
    //     String preViewItemUrl = yeedocProperties.getYeeDocLinkUrl() + "/api/item/external/previewitem/" + itemId + "" +
    //         "?ExternalSource=" + yeedocProperties.getExternalSource() +
    //         "&ExternalToken=" + externalToken;
    //     log.debug("[易道壳]-preViewItemUrl:{}", preViewItemUrl);
    //     return executePost(preViewItemUrl, new HashMap<>(3));
    // }

    /**
     * 在易道壳返回浏览链接
     *
     * @param itemId
     */
    @Override
    public String preViewItemPro(String itemId) {
        String yeedocJwt = getYeedocJwt();
        String preViewItemUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/GetItemDetailForTwCrm";
        HashMap<String, Object> map = new HashMap<>();
        map.put("ItemId", itemId);
        return executePost(preViewItemUrl, map, yeedocJwt);
    }

    /**
     * 删除易道壳的文件夹
     *
     * @param itemId
     */
    @Override
    public String deleteItem(String itemId) {
        String yeedocJwt = getYeedocJwt();
        return deleteItem(itemId, yeedocJwt);
    }

    /**
     * 删除易稻壳文件
     *
     * @param itemId    itemId
     * @param authToken 身份验证令牌
     * @return {@link String}
     */
    @Override
    public String deleteItem(String itemId, String authToken) {
        String deleteItemUrl = yeedocProperties.getYeeDocLinkUrl() + "/itemapi/Item/ItemRecycled";
        HashMap<String, Object> map = new HashMap<>();
        map.put("ItemId", Collections.singletonList(itemId));
        return executePost(deleteItemUrl, map, authToken);
    }

    /**
     * 通过用户信息生成易稻壳的jwt
     *
     * @param loginUser
     */
    @Override
    public String getYeedocJwt(SysUserDTO loginUser) {
        String sercretKey = yeedocProperties.getSercretKey();
        Map payloadMap = new HashMap<>();
        Map userInfoMap = new HashMap();
        userInfoMap.put("LoginName", loginUser.getEmail());
        userInfoMap.put("UserName", loginUser.getUsername());
        userInfoMap.put("UserMail", loginUser.getEmail());

        payloadMap.put("jwt", JSONUtil.toJsonStr(userInfoMap));
        payloadMap.put("exp", DateUtil.offsetDay(new Date(), 30));
        String token = JwtUtil.getToken(null, payloadMap, sercretKey);
        return token;
    }

    @Override
    public String getYeedocJwt() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        return getYeedocJwt(loginUser);
    }

    /**
     * 获取现在登录用户的token
     *
     * @return
     */
    private String getToken() {
        final Long userId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeDO prdOrgEmployeeDO = prdOrgEmployeeDAO.queryByUserId(userId);
        Assert.notNull(prdOrgEmployeeDO, "员工信息未维护");
        return prdOrgEmployeeDO.getPcLoginTicket();
    }

    /**
     * base64加密
     *
     * @param value
     * @return
     */
    private String base64Encrypt(String value) {
        byte[] b;
        String s = null;
        if (StringUtils.isEmpty(value)) {
            return value;
        }
        b = value.getBytes(StandardCharsets.UTF_8);
        if (b != null) {
            s = Base64.getEncoder().encodeToString(b);
        }
        return s;
    }

    /**
     * http post请求
     *
     * @param url 接口url
     * @param map
     * @return 返回接口数据
     */
    private String executePost(String url, Map<String, Object> map) {
        final String param = JSONObject.toJSONString(map);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        try {
            result = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .body(param, "application/json")
                //超时，毫秒
                .timeout(20000)
                .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    /**
     * http post请求
     *
     * @param url    url
     * @param object 对象
     * @return {@link String}
     */
    @Deprecated
    private String executePost(String url, Object object) {
        final String param = JSONObject.toJSONString(object);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        try {
            result = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .body(param, "application/json")
                //超时，毫秒
                .timeout(20000)
                .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, "", finalResult, finalStatus, time);
        return result;
    }

    /**
     * http post请求
     *
     * @param url       url
     * @param map
     * @param authToken
     * @return {@link String}
     */
    private String executePost(String url, Map<String, Object> map, String authToken) {
        final String param = JSONObject.toJSONString(map);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        Map<String, List<String>> headers = new HashMap<>();
        try {
            HttpRequest header = HttpRequest.post(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .header("Source", yeedocProperties.getSource())
                .header("AuthToken", authToken);
            headers = header.headers();
            result = header
                .body(param, "application/json")
                //超时，毫秒
                .timeout(20000)
                .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        log.info("请求地址：{}", url);
        log.info("请求参数：{}", param);
        log.info("请求头：{}", JSONUtil.toJsonStr(headers));
        log.info("返回结果：{}", result);
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, JSONUtil.toJsonStr(headers), finalResult, finalStatus, time);
        return result;
    }

    /**
     * http Put请求
     *
     * @param url       url
     * @param map
     * @param authToken
     * @return {@link String}
     */
    private String executePut(String url, Map<String, Object> map, String authToken) {
        final String param = JSONObject.toJSONString(map);
        String result;
        String status = HttpStatus.SC_OK + "";
        long start = System.currentTimeMillis();
        Map<String, List<String>> headers = new HashMap<>();
        try {
            HttpRequest header = HttpRequest.put(url)
                .header("Content-Type", "application/json;charset=utf-8")
                .header("Source", yeedocProperties.getSource())
                .header("AuthToken", authToken);
            headers = header.headers();
            result = header
                .body(param, "application/json")
                //超时，毫秒
                .timeout(20000)
                .execute().body();
        } catch (HttpException e) {
            status = "x";
            result = e.getMessage();
            e.printStackTrace();
        }
        long time = System.currentTimeMillis() - start;
        String finalResult = result;
        String finalStatus = status;
        log.info("请求地址：{}", url);
        log.info("请求参数：{}", param);
        log.info("请求头：{}", JSONUtil.toJsonStr(headers));
        log.info("返回结果：{}", result);
        apiRequestLogService.saveOutLog(ApiRequestLogTypeEnum.YEEDOC, url, RequestMethod.POST, param, JSONUtil.toJsonStr(headers), finalResult, finalStatus, time);
        return result;
    }

}
