package com.elitesland.tw.tw5.server.yeedocref.constants;

import lombok.Getter;

/**
 * 易稻壳yeedoc权限 枚举
 * <p>
 * /// <summary>
 * /// 所有者(所有权限)
 * /// </summary>
 * OWN,
 * /// <summary>
 * /// 读写(不可创建/删除，可重命名、编辑、预览)
 * /// </summary>
 * RW,
 * /// <summary>
 * /// 只读(仅预览)
 * /// </summary>
 * RO,
 * /// <summary>
 * /// 无
 * /// </summary>
 * NON
 * 业务类型
 *
 * @author duwh
 * @date 2023/12/08
 */
public enum YeedocPermissionsEnum {

    OWN("OWN", "所有者(所有权限)"),
    RW("RW", "读写(不可创建/删除，可重命名、编辑、预览)"),
    RO("RO", "只读(仅预览)"),
    NON("NON", "无"),

    ;


    @Getter
    private final String code;
    @Getter
    private final String desc;

    YeedocPermissionsEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
