package com.elitesland.tw.tw5.server.yeedocref.model.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * 通用易稻壳文件夹关系表DO
 * @author duwh
 * @date 2024-1-18
*/
@Entity
@Table(name = "prd_yeedoc_ref")
@org.hibernate.annotations.Table(appliesTo = "prd_yeedoc_ref", comment = "通用易稻壳文件夹关系表")
@Getter
@Setter
@Where(clause = "delete_flag = 0")
public class PrdYeedocRefDO extends BaseModel {

    @Comment("关联业务主键类型 PROJECT 项目 其他..")
    @Column
    private String refType;

    @Comment("关联业务主键 如：项目id")
    @Column
    private Long refId;

    @Comment("易稻壳文件夹id")
    @Column
    private String itemId;

    @Comment("易稻壳库id")
    @Column
    private String libraryId;

    @Comment("文件夹名称（冗余）")
    @Column
    private String itemName;

    @Comment("拓展字段1")
    @Column
    private String extString1;

    @Comment("拓展字段3")
    @Column
    private String extString3;

    @Comment("拓展字段2")
    @Column
    private String extString2;

}
