package com.elitesland.tw.tw5.server.yeedocref.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.yeedocref.constants.YeedocRefTypeEnum;
import com.elitesland.tw.tw5.server.yeedocref.model.payload.PrdYeedocRefPayload;
import com.elitesland.tw.tw5.server.yeedocref.model.query.PrdYeedocRefQuery;
import com.elitesland.tw.tw5.server.yeedocref.model.vo.PrdYeedocRefVO;

import java.util.List;


/**
 * 通用易稻壳文件夹关系表service
 * @author duwh
 * @date 2024/3/22
*/
public interface PrdYeedocRefService {

    /**
     * 分页查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<PagingVO<PrdYeedocRefVO>> queryPage(PrdYeedocRefQuery query);

    /**
     * 列表查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<List<PrdYeedocRefVO>> queryList(PrdYeedocRefQuery query);

    /**
     * count查询
     *
     * @param query query
     * @return result
     */
    TwOutputUtil<Long> queryCount(PrdYeedocRefQuery query);

    /**
     * 根据主键获取详情
     *
     * @param id 主键
     * @return result
     */
    TwOutputUtil<PrdYeedocRefVO> queryByKey(Long id);

    /**
     * 新增
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PrdYeedocRefVO> insert(PrdYeedocRefPayload payload);

    /**
     * 修改
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PrdYeedocRefVO> update(PrdYeedocRefPayload payload);

    /**
     * 动态修改，一般只用在少部分字段修改的场景，比如修改状态
     *
     * @param payload payload
     * @return result
     */
    TwOutputUtil<PrdYeedocRefVO> updateDynamic(PrdYeedocRefPayload payload);

    /**
     * 逻辑删除
     *
     * @param ids ids
     * @return result
     */
    TwOutputUtil<Long> deleteSoft(List<Long> ids);

    /**
     * 按引用类型和引用id查询
     *
     * @param yeedocRefTypeEnum yeedoc-ref类型枚举
     * @param projectId         项目id
     * @return {@link PrdYeedocRefVO}
     */
    PrdYeedocRefVO queryByRefTypeAndRefId(YeedocRefTypeEnum yeedocRefTypeEnum, Long projectId);
}
