package com.elitesland.tw.tw5.server.common.crontask.payload;

import lombok.Data;
import lombok.ToString;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>合同业绩统计明细【T_CONTRACT_ACHIEVE】</p>
 * <p>创建时间: 2023-01-05</p>
 * @version 1.0
 */
@Data
@ToString
public class TwContractAchieveEntity {
    /**
     *  【T_CONTRACT_ACHIEVE.id】
     */
    private Long id;

    /**
     * 合同id 【T_CONTRACT_ACHIEVE.contract_id】
     */
    private Integer contractId;

    /**
     * 部门类别 【T_CONTRACT_ACHIEVE.bu_type】
     */
    private String buType;

    /**
     * 部门 【T_CONTRACT_ACHIEVE.bu_id】
     */
    private Integer buId;

    /**
     * 统计分类 【T_CONTRACT_ACHIEVE.count_type】
     */
    private String countType;

    /**
     * 部门归属人员 【T_CONTRACT_ACHIEVE.charge_res_id】
     */
    private Integer chargeResId;

    /**
     * 比例 【T_CONTRACT_ACHIEVE.ratio】
     */
    private String ratio;

    /**
     * 金额 【T_CONTRACT_ACHIEVE.amt】
     */
    private BigDecimal amt;

    /**
     * 备注 【T_CONTRACT_ACHIEVE.remark】
     */
    private String remark;

    /**
     * 删除标志 【T_CONTRACT_ACHIEVE.del_flag】
     */
    private Integer delFlag = 0;

    /**
     * 创建者用户ID 【T_CONTRACT_ACHIEVE.create_user_id】
     */
    private Integer createUserId;

    /**
     * 创建时间 【T_CONTRACT_ACHIEVE.create_time】
     */
    private LocalDateTime createTime;

    /**
     * 修改者用户ID 【T_CONTRACT_ACHIEVE.modify_user_id】
     */
    private Integer modifyUserId;

    /**
     * 修改时间 【T_CONTRACT_ACHIEVE.modify_time】
     */
    private LocalDateTime modifyTime;

    /**
     *  价值角色 【T_CONTRACT_ACHIEVE.value_role】
     */
    private String valueRole;

    /**
     *  业绩统计V5_id 【T_CONTRACT_ACHIEVE.achieve_id_v5】
     */
    private Long achieveIdV5;

    /**
     *  业绩统计V4_id 【T_CONTRACT_ACHIEVE.achieve_id_v4】
     */
    private Long achieveIdV4;
}