package com.elitesland.tw.tw5.server.common.funConfig.dao;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPathExprPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigPathExprQuery;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigPathExprVO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigPathExprDO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.QBusinessDocTypeConfigPathExprDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigPathExprRepo;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import io.swagger.annotations.ApiModelProperty;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 文档配置函数表达式
 *
 * @author wangly
 * @date 2024-07-02
 */
@Repository
@RequiredArgsConstructor
public class BusinessDocTypeConfigPathExprDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessDocTypeConfigPathExprRepo repo;
    private final QBusinessDocTypeConfigPathExprDO qdo = QBusinessDocTypeConfigPathExprDO.businessDocTypeConfigPathExprDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypeConfigPathExprVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BusinessDocTypeConfigPathExprVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 函数ID
                qdo.functionId,
                // 易稻壳libraryId(文档库id)
                qdo.libraryId,
                // 易稻壳libraryId翻译
                qdo.libraryName,
                // 路径
                qdo.exprValue,
                // 路径映射
                qdo.exprValueDesc,
                // 数据库表名 prd_business_table.table_name
                qdo.tableName,
                // 数据库表名 prd_business_table.name
                qdo.tableNameDesc,
                // 业务对象字段明细主键 prd_business_table_fields.fieldid
                qdo.field,
                // 字段展示名称 prd_business_table_fields.show_name
                qdo.fieldShowName,
                // 排序号
                qdo.sortNo,
                // 拓展字段1
                qdo.ext1,
                // 拓展字段2
                qdo.ext2,
                // 拓展字段3
                qdo.ext3
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BusinessDocTypeConfigPathExprVO> getJpaQueryWhere(BusinessDocTypeConfigPathExprQuery query) {
        JPAQuery<BusinessDocTypeConfigPathExprVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BusinessDocTypeConfigPathExprQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BusinessDocTypeConfigPathExprQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 函数ID 精确 */
        if (!ObjectUtils.isEmpty(query.getFunctionId())) {
            list.add(qdo.functionId.eq(query.getFunctionId()));
        }
        /** 易稻壳libraryId(文档库id) 精确 */
        if (!ObjectUtils.isEmpty(query.getLibraryId())) {
            list.add(qdo.libraryId.eq(query.getLibraryId()));
        }
        /** 易稻壳libraryId翻译 精确 */
        if (!ObjectUtils.isEmpty(query.getLibraryName())) {
            list.add(qdo.libraryName.eq(query.getLibraryName()));
        }
        /** 路径 精确 */
        if (!ObjectUtils.isEmpty(query.getExprValue())) {
            list.add(qdo.exprValue.eq(query.getExprValue()));
        }
        /** 路径映射 精确 */
        if (!ObjectUtils.isEmpty(query.getExprValueDesc())) {
            list.add(qdo.exprValueDesc.eq(query.getExprValueDesc()));
        }
        /** 数据库表名 prd_business_table.table_name 精确 */
        if (!ObjectUtils.isEmpty(query.getTableName())) {
            list.add(qdo.tableName.eq(query.getTableName()));
        }
        /** 数据库表名 prd_business_table.name 精确 */
        if (!ObjectUtils.isEmpty(query.getTableNameDesc())) {
            list.add(qdo.tableNameDesc.eq(query.getTableNameDesc()));
        }
        /** 业务对象字段明细主键 prd_business_table_fields.fieldid 精确 */
        if (!ObjectUtils.isEmpty(query.getField())) {
            list.add(qdo.field.eq(query.getField()));
        }
        /** 业务对象字段明细主键 prd_business_table_fields.fieldid 精确 */
        if (!CollectionUtils.isEmpty(query.getFieldList())) {
            list.add(qdo.field.in(query.getFieldList()));
        }
        /** 字段展示名称 prd_business_table_fields.show_name 精确 */
        if (!ObjectUtils.isEmpty(query.getFieldShowName())) {
            list.add(qdo.fieldShowName.eq(query.getFieldShowName()));
        }
        /** 排序号 精确 */
        if (!ObjectUtils.isEmpty(query.getSortNo())) {
            list.add(qdo.sortNo.eq(query.getSortNo()));
        }
        /** 拓展字段1 精确 */
        if (!ObjectUtils.isEmpty(query.getExt1())) {
            list.add(qdo.ext1.eq(query.getExt1()));
        }
        /** 拓展字段2 精确 */
        if (!ObjectUtils.isEmpty(query.getExt2())) {
            list.add(qdo.ext2.eq(query.getExt2()));
        }
        /** 拓展字段3 精确 */
        if (!ObjectUtils.isEmpty(query.getExt3())) {
            list.add(qdo.ext3.eq(query.getExt3()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BusinessDocTypeConfigPathExprVO queryByKey(Long id) {
        JPAQuery<BusinessDocTypeConfigPathExprVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BusinessDocTypeConfigPathExprVO> queryListDynamic(BusinessDocTypeConfigPathExprQuery query) {
        JPAQuery<BusinessDocTypeConfigPathExprVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BusinessDocTypeConfigPathExprVO> queryPaging(BusinessDocTypeConfigPathExprQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BusinessDocTypeConfigPathExprVO> jpaQuery = getJpaQueryWhere(query);
        List<BusinessDocTypeConfigPathExprVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BusinessDocTypeConfigPathExprVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BusinessDocTypeConfigPathExprDO save(BusinessDocTypeConfigPathExprDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BusinessDocTypeConfigPathExprDO> saveAll(List<BusinessDocTypeConfigPathExprDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BusinessDocTypeConfigPathExprPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 函数ID
        if (payload.getFunctionId() != null) {
            update.set(qdo.functionId, payload.getFunctionId());
        }

        // 易稻壳libraryId(文档库id)
        if (payload.getLibraryId() != null) {
            update.set(qdo.libraryId, payload.getLibraryId());
        }
        // 易稻壳libraryId翻译
        if (payload.getLibraryName() != null) {
            update.set(qdo.libraryName, payload.getLibraryName());
        }
        // 路径
        if (payload.getExprValue() != null) {
            update.set(qdo.exprValue, payload.getExprValue());
        }
        // 路径映射
        if (payload.getExprValueDesc() != null) {
            update.set(qdo.exprValueDesc, payload.getExprValueDesc());
        }
        // 数据库表名 prd_business_table.table_name
        if (payload.getTableName() != null) {
            update.set(qdo.tableName, payload.getTableName());
        }
        // 数据库表名 prd_business_table.name
        if (payload.getTableNameDesc() != null) {
            update.set(qdo.tableNameDesc, payload.getTableNameDesc());
        }
        // 业务对象字段明细主键 prd_business_table_fields.fieldid
        if (payload.getField() != null) {
            update.set(qdo.field, payload.getField());
        }
        // 字段展示名称 prd_business_table_fields.show_name
        if (payload.getFieldShowName() != null) {
            update.set(qdo.fieldShowName, payload.getFieldShowName());
        }
        // 排序号
        if (payload.getSortNo() != null) {
            update.set(qdo.sortNo, payload.getSortNo());
        }
        // 拓展字段1
        if (payload.getExt1() != null) {
            update.set(qdo.ext1, payload.getExt1());
        }
        // 拓展字段2
        if (payload.getExt2() != null) {
            update.set(qdo.ext2, payload.getExt2());
        }
        // 拓展字段3
        if (payload.getExt3() != null) {
            update.set(qdo.ext3, payload.getExt3());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 函数ID
            if (nullFields.contains("functionId")) {
                update.setNull(qdo.functionId);
            }
            // 易稻壳libraryId(文档库id)
            if (nullFields.contains("libraryId")) {
                update.setNull(qdo.libraryId);
            }
            // 易稻壳libraryId翻译
            if (nullFields.contains("libraryName")) {
                update.setNull(qdo.libraryName);
            }
            // 路径
            if (nullFields.contains("exprValue")) {
                update.setNull(qdo.exprValue);
            }
            // 路径映射
            if (nullFields.contains("exprValueDesc")) {
                update.setNull(qdo.exprValueDesc);
            }
            // 数据库表名 prd_business_table.table_name
            if (nullFields.contains("tableName")) {
                update.setNull(qdo.tableName);
            }
            // 数据库表名 prd_business_table.name
            if (nullFields.contains("tableNameDesc")) {
                update.setNull(qdo.tableNameDesc);
            }
            // 业务对象字段明细主键 prd_business_table_fields.fieldid
            if (nullFields.contains("field")) {
                update.setNull(qdo.field);
            }
            // 字段展示名称 prd_business_table_fields.show_name
            if (nullFields.contains("fieldShowName")) {
                update.setNull(qdo.fieldShowName);
            }
            // 排序号
            if (nullFields.contains("sortNo")) {
                update.setNull(qdo.sortNo);
            }
            // 拓展字段1
            if (nullFields.contains("ext1")) {
                update.setNull(qdo.ext1);
            }
            // 拓展字段2
            if (nullFields.contains("ext2")) {
                update.setNull(qdo.ext2);
            }
            // 拓展字段3
            if (nullFields.contains("ext3")) {
                update.setNull(qdo.ext3);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

