package com.elitesland.tw.tw5.server.common.funConfig.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 文档配置函数表达式
 *
 * @author wangly
 * @date 2024-07-02
 */
@Entity
@Table(name = "prd_business_doc_type_config_path_expr", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_business_doc_type_config_path_expr", comment = "文档配置函数表达式")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BusinessDocTypeConfigPathExprDO extends BaseModel implements Serializable  {
    /**
     * 易稻壳libraryId(文档库id)
     */
    @ApiModelProperty("易稻壳libraryId(文档库id)")
    private String libraryId;
    /**
     * 易稻壳libraryId翻译
     */
    @ApiModelProperty("易稻壳libraryId翻译")
    private String libraryName;
    /** 路径 */
    @Comment("路径")
    @Column()
    private String exprValue;
    /** 路径映射 */
    @Comment("路径映射")
    @Column()
    private String exprValueDesc;
    /** 数据库表名 prd_business_table.table_name */
    @Comment("数据库表名 prd_business_table.table_name")
    @Column()
    private String tableName;
    /** 数据库表名 prd_business_table.name */
    @Comment("数据库表名 prd_business_table.name")
    @Column()
    private String tableNameDesc;
    /** 业务对象字段明细主键 prd_business_table_fields.fieldid */
    @Comment("业务对象字段明细主键 prd_business_table_fields.fieldid")
    @Column()
    private String field;
    /** 字段展示名称 prd_business_table_fields.show_name */
    @Comment("字段展示名称 prd_business_table_fields.show_name")
    @Column()
    private String fieldShowName;
    /** 业务对象ID */
    @Comment("业务对象ID")
    @Column()
    private Long functionId;
    /** 排序号 */
    @Comment("排序号")
    @Column()
    private Integer sortNo;
    /** 拓展字段1 */
    @Comment("拓展字段1")
    @Column()
    private String ext1;
    /** 拓展字段2 */
    @Comment("拓展字段2")
    @Column()
    private String ext2;
    /** 拓展字段3 */
    @Comment("拓展字段3")
    @Column()
    private String ext3;

    public void copy(BusinessDocTypeConfigPathExprDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
