package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypePermissionPrevRecordPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypePermissionPrevRecordQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypePermissionPrevRecordService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypePermissionPrevRecordVO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypePermissionPrevRecordConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypePermissionPrevRecordDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypePermissionPrevRecordDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypePermissionPrevRecordRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 通用文档-易稻壳赋权预览地址获取记录表
 *
 * @author duwh
 * @date 2023-12-09
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypePermissionPrevRecordServiceImpl extends BaseServiceImpl implements BusinessDocTypePermissionPrevRecordService {

    private final BusinessDocTypePermissionPrevRecordRepo businessDocTypePermissionPrewRecordRepo;
    private final BusinessDocTypePermissionPrevRecordDAO businessDocTypePermissionPrewRecordDAO;

    @Override
    public PagingVO<BusinessDocTypePermissionPrevRecordVO> queryPaging(BusinessDocTypePermissionPrevRecordQuery query){
        return businessDocTypePermissionPrewRecordDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDocTypePermissionPrevRecordVO> queryListDynamic(BusinessDocTypePermissionPrevRecordQuery query){
        return businessDocTypePermissionPrewRecordDAO.queryListDynamic(query);
    }

    @Override
    public BusinessDocTypePermissionPrevRecordVO queryByKey(Long key) {
        BusinessDocTypePermissionPrevRecordDO entity = businessDocTypePermissionPrewRecordRepo.findById(key).orElseGet(BusinessDocTypePermissionPrevRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypePermissionPrevRecordVO vo = BusinessDocTypePermissionPrevRecordConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypePermissionPrevRecordVO insert(BusinessDocTypePermissionPrevRecordPayload payload) {
        BusinessDocTypePermissionPrevRecordDO entityDo = BusinessDocTypePermissionPrevRecordConvert.INSTANCE.toDo(payload);
        return BusinessDocTypePermissionPrevRecordConvert.INSTANCE.toVo(businessDocTypePermissionPrewRecordRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypePermissionPrevRecordVO update(BusinessDocTypePermissionPrevRecordPayload payload) {
        BusinessDocTypePermissionPrevRecordDO entity = businessDocTypePermissionPrewRecordRepo.findById(payload.getId()).orElseGet(BusinessDocTypePermissionPrevRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypePermissionPrevRecordDO entityDo = BusinessDocTypePermissionPrevRecordConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypePermissionPrevRecordConvert.INSTANCE.toVo(businessDocTypePermissionPrewRecordRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypePermissionPrevRecordPayload payload) {
        BusinessDocTypePermissionPrevRecordDO entity = businessDocTypePermissionPrewRecordRepo.findById(payload.getId()).orElseGet(BusinessDocTypePermissionPrevRecordDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypePermissionPrewRecordDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypePermissionPrewRecordDAO.deleteSoft(keys);
        }
    }

}
