package com.elitesland.tw.tw5.server.common.funConfig.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTablePayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.query.TableQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.TableInfo;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessTableConvert;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableDAO;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessTableFieldsDAO;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessTableDO;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessTableRepo;
import com.elitesland.tw.tw5.server.common.funConfig.util.CodeGenUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * 业务对象表
 *
 * @author duwh
 * @date 2023-06-14
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessTableServiceImpl extends BaseServiceImpl implements BusinessTableService {

    private final BusinessTableRepo businessTableRepo;
    private final BusinessTableDAO businessTableDAO;
    private final BusinessTableFieldsDAO businessTableFieldsDAO;
    @PersistenceContext
    private EntityManager em;

    @Override
    public PagingVO<BusinessTableVO> queryPaging(BusinessTableQuery query) {
        return businessTableDAO.queryPaging(query);
    }

    @Override
    public List<BusinessTableVO> queryListDynamic(BusinessTableQuery query) {
        return businessTableDAO.queryListDynamic(query);
    }

    @Override
    public List<BusinessTableVO> listAll(BusinessTableQuery query) {
        List<BusinessTableVO> businessTableVOS = businessTableDAO.queryListDynamic(query);
        businessTableVOS.forEach(businessTableVO -> {
            Long id = businessTableVO.getId();
            BusinessTableFieldsQuery fieldsQuery = new BusinessTableFieldsQuery();
            fieldsQuery.setTableId(id);
            List<BusinessTableFieldsVO> businessTableFieldsVOS = businessTableFieldsDAO.queryListDynamic(fieldsQuery);
            businessTableVO.setFieldsVOList(businessTableFieldsVOS);
        });
        return businessTableVOS;
    }

    @Override
    public BusinessTableVO queryByKey(Long key) {
        BusinessTableDO entity = businessTableRepo.findById(key).orElseGet(BusinessTableDO::new);
        Assert.notNull(entity.getId(), "业务对象不存在");
        BusinessTableVO vo = BusinessTableConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableVO insert(BusinessTablePayload payload) {
        BusinessTableDO entityDo = BusinessTableConvert.INSTANCE.toDo(payload);
        return BusinessTableConvert.INSTANCE.toVo(businessTableRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessTableVO update(BusinessTablePayload payload) {
        BusinessTableDO entity = businessTableRepo.findById(payload.getId()).orElseGet(BusinessTableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessTableDO entityDo = BusinessTableConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessTableConvert.INSTANCE.toVo(businessTableRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessTablePayload payload) {
        BusinessTableDO entity = businessTableRepo.findById(payload.getId()).orElseGet(BusinessTableDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessTableDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessTableDAO.deleteSoft(keys);
        }
    }

    @Override
    public PagingVO<TableInfo> tables(TableQuery param) {
        // 使用预编译防止sql注入
        String sql = "select table_name ,create_time , engine, table_collation, table_comment from information_schema.tables " +
                "where table_schema = (select database()) " +
                "and table_name like :table order by create_time desc";
        int start = getStart(param.getCurrent(), param.getSize());
        Query query = em.createNativeQuery(sql);
        query.setFirstResult(param.getSize());
        query.setMaxResults(param.getSize() - start);
        String tableName = param.getTableName();
        query.setParameter("table", StringUtils.isNotBlank(tableName) ? ("%" + tableName + "%") : "%%");
        List result = query.getResultList();
        List<TableInfo> tableInfos = new ArrayList<>();
        for (Object obj : result) {
            Object[] arr = (Object[]) obj;
            tableInfos.add(new TableInfo(arr[0], arr[1], arr[2], arr[3], ObjectUtil.isNotEmpty(arr[4]) ? arr[4] : "-"));
        }
        String countSql = "select count(1) from information_schema.tables " +
                "where table_schema = (select database()) and table_name like :table";
        Query queryCount = em.createNativeQuery(countSql);
        queryCount.setParameter("table", StringUtils.isNotBlank(tableName) ? ("%" + tableName + "%") : "%%");
        Object totalElements = queryCount.getSingleResult();
        Long total = Long.valueOf(totalElements.toString());
        return PagingVO.<TableInfo>builder().records(tableInfos).total(total).build();
    }

    /**
     * 代码生成
     *
     * @param id            id
     * @param projectModule 领域 tw crm pms
     * @param apiGorupName  apifox 接口文档分组 组名称
     * @param packageName   包名
     * @param author        作者
     * @param moduleName    模块名称
     * @param prefix        去除表格前缀 前缀
     * @param cover         是否覆盖已生成的文件
     */
    @Override
    public void generator(Long id, String projectModule,
                          String apiGorupName,
                          String packageName,
                          String author,
                          String moduleName,
                          String prefix,
                          boolean cover) {
        BusinessTableVO businessTableVO = queryByKey(id);

        BusinessTableFieldsQuery businessTableFieldsQuery = new BusinessTableFieldsQuery();
        businessTableFieldsQuery.setTableId(id);
        List<BusinessTableFieldsVO> fieldsVOList = businessTableFieldsDAO.queryListDynamic(businessTableFieldsQuery);
        try {
            // 生成代码
            CodeGenUtil.generatorCode(fieldsVOList, businessTableVO, projectModule, apiGorupName, packageName, author, moduleName, prefix, cover);
        } catch (IOException e) {
            log.error(e.getMessage(), e);
            throw TwException.error("", "生成失败，请手动处理已生成的文件");
        }
    }


    public static int getStart(int pageNo, int pageSize) {
        if (pageNo < 0) {
            pageNo = 0;
        }

        if (pageSize < 1) {
            pageSize = 0;
        }

        return (pageNo - 0) * pageSize;
    }


}
