package com.elitesland.tw.tw5.server.prd.acc.dao;


import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverdueDiscuntPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueDiscuntQuery;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueDiscuntVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDiscuntDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccReimSettingOverdueDiscuntDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueDiscuntRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 报销逾期打折表
 *
 * @author zoey
 * @date 2024-04-08
 */
@Repository
@RequiredArgsConstructor
public class AccReimSettingOverdueDiscuntDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AccReimSettingOverdueDiscuntRepo repo;
    private final QAccReimSettingOverdueDiscuntDO qdo = QAccReimSettingOverdueDiscuntDO.accReimSettingOverdueDiscuntDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingOverdueDiscuntVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AccReimSettingOverdueDiscuntVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 报销逾期规则配置主表id
                qdo.reimSettingOverdueId,
                // 日期区间开始（包含）
                qdo.minDays,
                // 日期区间结束（不包含）
                qdo.maxDays,
                // 折扣（0~10）
                qdo.invLimit
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AccReimSettingOverdueDiscuntVO> getJpaQueryWhere(AccReimSettingOverdueDiscuntQuery query) {
        JPAQuery<AccReimSettingOverdueDiscuntVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AccReimSettingOverdueDiscuntQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AccReimSettingOverdueDiscuntQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 报销逾期规则配置主表id 精确 */
        if (!ObjectUtils.isEmpty(query.getReimSettingOverdueId())) {
            list.add(qdo.reimSettingOverdueId.eq(query.getReimSettingOverdueId()));
        }
        /** 日期区间开始（包含） 精确 */
        if (!ObjectUtils.isEmpty(query.getMinDays())) {
            list.add(qdo.minDays.eq(query.getMinDays()));
        }
        /** 日期区间结束（不包含） 精确 */
        if (!ObjectUtils.isEmpty(query.getMaxDays())) {
            list.add(qdo.maxDays.eq(query.getMaxDays()));
        }
        /** 折扣（0~10） 精确 */
        if (!ObjectUtils.isEmpty(query.getInvLimit())) {
            list.add(qdo.invLimit.eq(query.getInvLimit()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AccReimSettingOverdueDiscuntVO queryByKey(Long id) {
        JPAQuery<AccReimSettingOverdueDiscuntVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AccReimSettingOverdueDiscuntVO> queryListDynamic(AccReimSettingOverdueDiscuntQuery query) {
        JPAQuery<AccReimSettingOverdueDiscuntVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AccReimSettingOverdueDiscuntVO> queryPaging(AccReimSettingOverdueDiscuntQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<AccReimSettingOverdueDiscuntVO> jpaQuery = getJpaQueryWhere(query);
        List<AccReimSettingOverdueDiscuntVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AccReimSettingOverdueDiscuntVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AccReimSettingOverdueDiscuntDO save(AccReimSettingOverdueDiscuntDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AccReimSettingOverdueDiscuntDO> saveAll(List<AccReimSettingOverdueDiscuntDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AccReimSettingOverdueDiscuntPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 报销逾期规则配置主表id
        if (payload.getReimSettingOverdueId() != null) {
            update.set(qdo.reimSettingOverdueId, payload.getReimSettingOverdueId());
        }
        // 日期区间开始（包含）
        if (payload.getMinDays() != null) {
            update.set(qdo.minDays, payload.getMinDays());
        }
        // 日期区间结束（不包含）
        if (payload.getMaxDays() != null) {
            update.set(qdo.maxDays, payload.getMaxDays());
        }
        // 折扣（0~10）
        if (payload.getInvLimit() != null) {
            update.set(qdo.invLimit, payload.getInvLimit());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 报销逾期规则配置主表id
            if (nullFields.contains("reimSettingOverdueId")) {
                update.setNull(qdo.reimSettingOverdueId);
            }
            // 日期区间开始（包含）
            if (nullFields.contains("minDays")) {
                update.setNull(qdo.minDays);
            }
            // 日期区间结束（不包含）
            if (nullFields.contains("maxDays")) {
                update.setNull(qdo.maxDays);
            }
            // 折扣（0~10）
            if (nullFields.contains("invLimit")) {
                update.setNull(qdo.invLimit);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

