package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 会计科目管理
 *
 * @author carl
 * @date 2023-09-25
 */
@Entity
@Table(name = "acc_financial_subject", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_financial_subject", comment = "会计科目管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccFinancialSubjectDO extends BaseModel implements Serializable  {
    /** 科目编号 */
    @Comment("科目编号")
    @Column()
    private String accCode;
    /** 上级科目主键 */
    @Comment("上级科目主键")
    @Column()
    private Long parentId;
    /** 上级科目编号 */
    @Comment("上级科目编号")
    @Column()
    private String upperCode;
    /** 科目行业 */
    @Comment("科目行业")
    @Column()
    private String accIndustrys;
    /** 科目名称 */
    @Comment("科目名称")
    @Column()
    private String accName;
    /** 科目简称 */
    @Comment("科目简称")
    @Column()
    private String accAbbr;
    /** 科目状态 */
    @Comment("科目状态")
    @Column()
    private String accStatus;
    /** 科目级别 */
    @Comment("科目级别")
    @Column()
    private Integer accLevel;
    /** 汇总科目（0：否，1：是） */
    @Comment("汇总科目（0：否，1：是）")
    @Column()
    private Integer sumFlag;
    /** 明细账 */
    @Comment("明细账")
    @Column()
    private String dtlAcc;
    /** 处理码 */
    @Comment("处理码")
    @Column()
    private String procCode;
    /** 子账标记 */
    @Comment("子账标记")
    @Column()
    private Integer ledgerFlag;
    /** 子账类型 */
    @Comment("子账类型")
    @Column()
    private String ledgerType;
    /** 大类 */
    @Comment("大类")
    @Column()
    private String accType1;
    /** 明细类1 */
    @Comment("明细类1")
    @Column()
    private String accType2;
    /** 明细类2 */
    @Comment("明细类2")
    @Column()
    private String accType3;
    /** 类别1 */
    @Comment("类别1")
    @Column()
    private String accCat1;
    /** 类别2 */
    @Comment("类别2")
    @Column()
    private String accCat2;
    /** 类别3 */
    @Comment("类别3")
    @Column()
    private String accCat3;
    /** 类别4 */
    @Comment("类别4")
    @Column()
    private String accCat4;
    /** 类别5 */
    @Comment("类别5")
    @Column()
    private String accCat5;
    /** 账套名称 */
    @Comment("账套名称")
    @Column()
    private String accsetName;
    /** 借贷类型 */
    @Comment("借贷类型")
    @Column()
    private String drcrType;

    public void copy(AccFinancialSubjectDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
