package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author sunxw
 * @description 报销单头表
 * @Date 2023/11/22
 */
@Entity
@Table(name = "acc_reim", indexes = {
        @Index(name = "idx_reason_type_reason_id", columnList = "reason_type,reason_id"),
        @Index(name = "idx_reim_status", columnList = "reim_status"),
        @Index(name = "idx_reim_no", columnList = "reim_no"),
        @Index(name = "idx_fin_period_id", columnList = "fin_period_id")
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim", comment = "报销单主表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimDO extends BaseModel implements Serializable {

    @Comment("报销单号")
    @Column(name = "reim_no")
    private String reimNo;

    @Comment("报销人USER_ID")
    @Column()
    private Long reimUserId;

    @Comment("报销人ORG_ID")
    @Column()
    private Long reimOrgId;

    @Comment("报销人职级")
    @Column()
    private String reimResGrade;

    @Comment("报销类型")
    @Column()
    private String reimType;

    @Comment("单据类型")
    @Column()
    private String reimDocType;

    @Comment("相关申请单ID")
    @Column()
    private Long relatedDocId;

    @Comment("相关申请单名称")
    @Column()
    private String relatedDocName;

    @Comment("相关预算")
    @Column()
    private Long relatedBudgetId;

    /**
     * 费用归属 【P_reim_.expense_classification】
     */
    @Comment("费用归属")
    @Column()
    private String expenseClassification;

    @Comment("费用承担项目")
    @Column()
    private Long expenseProjectId;

    @Comment("费用承担部门")
    @Column()
    private Long expenseOrgId;

    @Comment("费用承担公司(book_id)")
    @Column()
    private Long expenseCompany;

    @Comment("报销单状态")
    @Column(name = "reim_status")
    private String reimStatus;

    @Comment("报销说明")
    @Column()
    private String reimRemark;

    @Comment("报销总额")
    @Column()
    private BigDecimal reimTotalAmt;

    @Comment("调整后费用")
    @Column()
    private BigDecimal adjustAmt;


    @Comment("借款核销金额")
    @Column()
    private BigDecimal  borrowWriteOffAmt;

    @Comment("实际请款金额")
    @Column()
    private BigDecimal payAmt;

    @Comment("事由类型")
    @Column(name = "reason_type")
    private String reasonType;

    @Comment("事由号")
    @Column(name = "reason_id")
    private Long reasonId;

    @Comment("事由名称")
    @Column()
    private String reasonName;

    @Comment("付款方式 转账等")
    @Column()
    private String payMethod;

    @Comment("收款账户")
    @Column()
    private String accountNo;

    @Comment("户名")
    @Column()
    private String holderName;

    @Comment("收款银行")
    @Column()
    private String bankName;

    @Comment("收款银行网点")
    @Column()
    private String bankBranch;

    @Comment("支付方式：1.网银支付 2.手动支付")
    @Column()
    private String payMode;

    @Comment("付款银行账号")
    @Column()
    private String payAccountNo;

    @Comment("费用承担方")
    @Column()
    private String expenseByType;

    @Comment("记账时间")
    @Column()
    private LocalDateTime accountingDate;

    @Comment("审批状态")
    @Column()
    private String apprStatus;

    @Comment("流程实例id")
    @Column()
    private String procInstId;

    @Comment("流程实例名称")
    @Column()
    private String procInstName;

    @Comment("财务收单时间")
    @Column()
    private LocalDateTime finChargeUpTime;

    @Comment("报销导出批次号，T_ACC_PAY_BATCH.BATCH_NO")
    @Column()
    private String batchNo;

    @Comment("新批次号")
    @Column()
    private String batchNoLast;

    @Comment("付款时间")
    @Column()
    private LocalDateTime payDate;

    @Comment("支付状态：S 成功、F 失败、C 撤销、D 过期、R 否决 G退票")
    @Column()
    private String payStatus;

    @Comment("网银提交标识 1.已提交 2.未提交")
    @Column()
    private Integer bankFlag;

    @Comment("网银提交时间")
    @Column()
    private LocalDateTime bankTime;

    @Comment("附件")
    @Column()
    private String fileCode;

    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;

    @Comment("财务负责人审批时间")
    @Column()
    private LocalDateTime finPicApprTime;

    @Comment("流程节点名称")
    @Column()
    private String apprProcName;

    @Comment("合同ID")
    @Column()
    private Long contractId;

    @Comment("财务期间ID")
    @Column(name = "fin_period_id")
    private Long finPeriodId;

    @Comment("财务稽核专员退回标记 0-未退回 1-退回")
    @Column()
    private Integer finRejectFlag;

    @Comment("财务代收单的流程节点key")
    @Column()
    private String procTaskKey;

    @Comment("是否异常")
    @Column()
    private Integer abnormalFlag;

    @Comment("报销明细是否需要事由")
    @Column()
    private Integer reimDetailFlag;

    @Comment("扩展字段1")
    @Column()
    private String ext1;

    @Comment("扩展字段2")
    @Column()
    private String ext2;

    @Comment("扩展字段3")
    @Column()
    private String ext3;

    @Comment("扩展字段4")
    @Column()
    private String ext4;

    @Comment("扩展字段5")
    @Column()
    private String ext5;

    @Comment("扩展字段6")
    @Column()
    private String ext6;

    @Column()
    @Comment("审批时间")
    private LocalDateTime approvedTime;

    public void copy(AccReimDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
