package com.elitesland.tw.tw5.server.prd.acc.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 报销明细餐费记录
 *
 * @author zoey
 * @date 2024-06-12
 */
@Entity
@Table(name = "acc_reim_detail_meal", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "acc_reim_detail_meal", comment = "报销明细餐费记录")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AccReimDetailMealDO extends BaseModel implements Serializable {
    /**
     * 报销单明细ID
     */
    @Comment("报销单明细ID")
    @Column()
    private Long reimDetailId;
    /**
     * 打卡记录id
     */
    @Comment("打卡记录id")
    @Column()
    private Long attendanceId;
//    /**
//     * 法定假期id
//     */
//    @Comment("法定假期id")
//    @Column()
//    private Integer vacationId;
    /**
     * 附件
     */
    @Comment("附件")
    @Column()
    private String fileCode;
    /**
     * 餐费日期
     */
    @Comment("餐费日期")
    @Column()
    private LocalDate mealDate;

    /**
     * 餐费
     */
    @Comment("餐费")
    @Column()
    private BigDecimal mealAmt;

    /**
     * 打卡城市
     */
    @Comment("打卡城市")
    @Column()
    private String attendanceCity;

    public void copy(AccReimDetailMealDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
