package com.elitesland.tw.tw5.server.prd.acc.repo;


import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * 报销配置主表
 *
 * @author zoey
 * @date 2024-04-08
 */
public interface AccReimSettingRepo extends JpaRepository<AccReimSettingDO, Long>, JpaSpecificationExecutor<AccReimSettingDO> {

    @Query(nativeQuery = true, value = "select GROUP_CONCAT(b.org_name) as noticeName from prd_message_config a,prd_org_organization b where b.delete_flag=0 and FIND_IN_SET(b.id,a.notice_source) and a.id=?1")
    String getOrgNames(long id);

    @Query(nativeQuery = true, value = "select GROUP_CONCAT(b.role_name) as noticeName from prd_message_config a,prd_system_role b where b.delete_flag=0 and FIND_IN_SET(b.id,a.notice_source) and a.id=?1")
    String getRoleNames(long id);

    int countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndDeleteFlag(String reimSettingType, String reimDocType, String expenseCompany, String applicationScope,Integer deleteFlag);

    int countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndApplicationSourceLikeAndDeleteFlag(String reimSettingType,String reimDocType,String expenseCompany,String applicationScope,String applicationSource,Integer deleteFlag);

    int countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndIdNotAndDeleteFlag(String reimSettingType,String reimDocType,String expenseCompany,String applicationScope,Long id,Integer deleteFlag);

    int countByReimSettingTypeAndReimDocTypeLikeAndExpenseCompanyLikeAndApplicationScopeAndApplicationSourceLikeAndIdNotAndDeleteFlag(String reimSettingType,String reimDocType,String expenseCompany,String applicationScope,String applicationSource,Long id,Integer deleteFlag);
}
