package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimTripStdPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimTripStdQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimTripStdService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimTripStdVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimTripStdConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimTripStdDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimTripStdDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimTripStdRepo;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.salecon.common.functionEnum.ConCustBearEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 差旅报销额度管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimTripStdServiceImpl extends BaseServiceImpl implements AccReimTripStdService {

    @Value("${tw5.reim.trip.breakfastScale:0.2}")
    private BigDecimal breakfastScale;
    @Value("${tw5.reim.trip.lunchScale:0.4}")
    private BigDecimal lunchScale;
    @Value("${tw5.reim.trip.dinnerScale:0.4}")
    private BigDecimal dinnerScale;
    @Value("${tw5.reim.trip.deductFee:10}")
    private BigDecimal deductFee;
    private final AccReimTripStdRepo repo;
    private final AccReimTripStdDAO dao;
    private final PrdOrgEmployeeService employeeService;

    @Override
    public PagingVO<AccReimTripStdVO> queryPaging(AccReimTripStdQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<AccReimTripStdVO> queryListDynamic(AccReimTripStdQuery query) {
        if (ObjectUtils.isEmpty(query.getJobGrade())) {
            Long userId = GlobalUtil.getLoginUserId();
            PrdOrgEmployeeVO prdOrgEmployeeVO = employeeService.queryByUserId(userId);
            String jobGrade = prdOrgEmployeeVO.getExtString1();
            query.setJobGrade(jobGrade);
        }
        List<AccReimTripStdVO> voList = dao.queryListDynamic(query);
        if (ObjectUtils.isEmpty(voList)) {
            return voList;
        }
        voList.forEach(
                vo -> {
                    BigDecimal oriFeeAmt = vo.getFeeAmt();
                    BigDecimal breakfastFee = oriFeeAmt.multiply(breakfastScale);
                    BigDecimal lunchFee = oriFeeAmt.multiply(lunchScale);
                    BigDecimal dinnerFee = oriFeeAmt.multiply(dinnerScale);
                    //如果费用承担方为客户提供项目餐，每餐进行扣减
                    if (!ObjectUtils.isEmpty(query.getExpenseByType()) && ConCustBearEnum.SUPP_MEALS.getCode().equals(query.getExpenseByType())) {
                        breakfastFee = breakfastFee.subtract(deductFee);
                        lunchFee = lunchFee.subtract(deductFee);
                        dinnerFee = dinnerFee.subtract(deductFee);
                        oriFeeAmt = oriFeeAmt.subtract((deductFee.multiply(new BigDecimal(3))));
                    }
                    vo.setFeeAmt(oriFeeAmt);
                    vo.setBreakfastFee(breakfastFee);
                    vo.setLunchFee(lunchFee);
                    vo.setDinnerFee(dinnerFee);
                }
        );
        return voList;
    }

    @Override
    public AccReimTripStdVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    @Transactional
    public AccReimTripStdVO insert(AccReimTripStdPayload payload) {
        AccReimTripStdDO entityDo = AccReimTripStdConvert.INSTANCE.toDo(payload);
        return AccReimTripStdConvert.INSTANCE.toVo(repo.save(entityDo));
    }

    @Override
    @Transactional
    public AccReimTripStdVO update(AccReimTripStdPayload payload) {
        AccReimTripStdDO entity = repo.findById(payload.getId()).orElseGet(AccReimTripStdDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimTripStdDO entityDo = AccReimTripStdConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimTripStdConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimTripStdPayload payload) {
        AccReimTripStdDO entity = repo.findById(payload.getId()).orElseGet(AccReimTripStdDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = dao.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
        }
    }

}
