package com.elitesland.tw.tw5.server.prd.adm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDate;

/**
 * 出差申请明细管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Entity
@Table(name = "adm_busitrip_apply_detail", indexes = {
        @Index(name = "apply_index", columnList = "apply_id")
})
@org.hibernate.annotations.Table(appliesTo = "adm_busitrip_apply_detail", comment = "出差申请明细管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AdmBusitripApplyDetailDO extends BaseModel implements Serializable {
    /**
     * 申请id
     */
    @Comment("申请id")
    @Column(name = "apply_id")
    private Long applyId;
    /**
     * 出差人资源id
     */
    @Comment("出差人资源id")
    @Column()
    private Long tripResId;
    /**
     * 出发地
     */
    @Comment("出发地")
    @Column()
    private String fromPlace;
    /**
     * 目的地
     */
    @Comment("目的地")
    @Column()
    private String toPlace;
    /**
     * 交通工具
     */
    @Comment("交通工具")
    @Column()
    private String vehicle;
    /**
     * 出发日期
     */
    @Comment("出发日期")
    @Column()
    private LocalDate beginDate;
    /**
     * 结束日期
     */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /**
     * 出发时间段
     */
    @Comment("出发时间段")
    @Column()
    private String beginTimespan;
    /**
     * 结束时间段
     */
    @Comment("结束时间段")
    @Column()
    private String endTimespan;

    public void copy(AdmBusitripApplyDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
