package com.elitesland.tw.tw5.server.prd.adm.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmFeeApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmFeeApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyDetailService;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmFeeApplyService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmFeeApplyVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmFeeApplyConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmFeeApplyDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmFeeApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmFeeApplyRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FeeApplyStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.system.constant.MessageNoticeTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 特殊费用申请管理
 *
 * @author carl
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AdmFeeApplyServiceImpl extends BaseServiceImpl implements AdmFeeApplyService {

    private final AdmFeeApplyRepo admFeeApplyRepo;
    private final AdmFeeApplyDAO admFeeApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final CacheUtil cacheUtil;
    private final PmsProjectService pmsProjectService;
    private final AdmFeeApplyDetailService admFeeApplyDetailService;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AdmFeeApplyVO insertOrUpdate(AdmFeeApplyPayload payload) {
        // 数据校验
        AdmFeeApplyVO admFeeApplyVO = checkData(payload);
        PmsProjectVO pmsProjectVO = null;
        if (payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            pmsProjectVO = pmsProjectService.queryByKey(payload.getReasonId());
            payload.setExpenseBuId(pmsProjectVO.getDeliBuId());
        }
        payload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
        if (admFeeApplyVO == null) {
            String code = generateSeqNum("AMD_FEE_APPLY");
            payload.setApplyNo(code);
            payload.setApplyDate(LocalDate.now());
        } else {
            payload.setApplyStatus(admFeeApplyVO.getApplyStatus());
            payload.setProcInstId(admFeeApplyVO.getProcInstId());
            payload.setApplyDate(admFeeApplyVO.getApplyDate());
        }
        AdmFeeApplyDO entityDo = AdmFeeApplyConvert.INSTANCE.toDo(payload);
        AdmFeeApplyDO save = admFeeApplyRepo.save(entityDo);
        //删除明细
        if (!ObjectUtils.isEmpty(payload.getDelDetailIds())) {
            admFeeApplyDetailService.deleteSoft(payload.getDelDetailIds());
        }

        //批量保存明细
        if (!ObjectUtils.isEmpty(payload.getDetailPayloads())) {
            payload.getDetailPayloads().forEach(act -> {
                if (act.getApplyAmt() == null || act.getApplyAmt().compareTo(BigDecimal.ZERO) <= 0) {
                    throw TwException.error("", "费用金额需大于0");
                }
                act.setApplyId(save.getId());
            });
            admFeeApplyDetailService.bacthInsert(payload.getDetailPayloads());
        }

        String apprStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
        String applyStatus = FeeApplyStatusEnum.APPLYING.getCode();
        String procInstId = null;
        if (admFeeApplyVO != null) {
            procInstId = admFeeApplyVO.getProcInstId();
        }
        //获取流程参数
        HashMap<String, Object> variables = getVariables(payload);
        if (procInstId == null) {
            String selection = cacheUtil.transferSystemSelection("ADM:COST:USE_TYPE", payload.getUsageType());
            String procName = "A06.特殊费用申请-" + selection + "-" + cacheUtil.getUserName(payload.getApplyResId());
            ;//流程名称
            //新建审批流
            ProcessInfo processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    "AMD_FEE_APPLY",
                    procName,
                    entityDo.getId() + "",
                    variables)
            );
            procInstId = processInfo.getProcInstId();
            apprStatus = processInfo.getProcInstStatus().name();
            if (apprStatus.equals(ProcInstStatus.APPROVED.name())) {
                applyStatus = FeeApplyStatusEnum.APPROVED.getCode();
                procInstId = null;
            }
        } else {
            //修改流程实例节点审批人
            workflowUtil.setVariables(SetVariablesPayload.of(procInstId, variables));
        }
        AdmFeeApplyPayload payload0 = new AdmFeeApplyPayload();
        payload0.setId(entityDo.getId());
        payload0.setProcInstId(procInstId);
        payload0.setApprStatus(apprStatus);
        payload0.setApplyStatus(applyStatus);
        //payload.setNullFields(List.of("procInstId"));
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            admFeeApplyDAO.updateByKeyDynamic(payload0);
        });
        return AdmFeeApplyConvert.INSTANCE.toVo(save);
    }

    HashMap<String, Object> getVariables(AdmFeeApplyPayload payload) {
        //新建审批流
        HashMap<String, Object> batchMap = new HashMap<>();
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        //直属上级
        batchMap.put("Activity_1lrfsda", Lists.newArrayList(userDefaultOrg.getParentId()));

        PrdOrgOrganizationVO org = cacheUtil.getOrg(payload.getExpenseBuId());
        //费用承担BU负责人审批
        batchMap.put("Activity_0ia1fug", Lists.newArrayList(org.getManageId()));
        //费用承担事业部负责人审批
        PrdOrgOrganizationRefVO organizationRefVO = cacheUtil.getBULevel1ByOrgId(org.getId());
        if(organizationRefVO==null){
            throw TwException.error("","费用承担事业部负责人为空！");
        }
        batchMap.put("Activity_1ij2306", Lists.newArrayList(organizationRefVO.getManageId()));
        //平台总体负责人审批
        batchMap.put("Activity_0vg7sa8", roleService.queryUserIdByRoleCode(RoleEnum.PLAT_ALL_PIC.getCode()));
        return batchMap;
    }

    /**
     * 数据校验
     *
     * @param payload
     */
    AdmFeeApplyVO checkData(AdmFeeApplyPayload payload) {
        if (!StringUtils.hasText(payload.getReasonType())) {
            throw TwException.error("", "事由类型不可为空，请核验！");
        }
        if (payload.getReasonId() == null) {
            throw TwException.error("", "归属事由不可为空，请核验！");
        }
        if (!StringUtils.hasText(payload.getReasonName())) {
            throw TwException.error("", "归属事由名称不可为空，请核验！");
        }
        if (!payload.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            if (payload.getExpenseBuId() == null) {
                throw TwException.error("", "费用承担bu不可为空");
            }
        }
        if (payload.getApplyResId() == null) {
            throw TwException.error("", "申请人不可为空，请核验！");
        }
        //赋值bu id
        PrdOrgEmployeeRefVO userDefaultOrg = cacheUtil.getUserDefaultOrg(payload.getApplyResId());
        payload.setApplyBuId(userDefaultOrg.getOrgId());
        AdmFeeApplyVO admFeeApplyVO = null;
        if (payload.getId() != null) {
            admFeeApplyVO = admFeeApplyDAO.queryByKey(payload.getId());
            if (admFeeApplyVO == null) {
                throw TwException.error("", "修改数据不存在");
            }
            if (!admFeeApplyVO.getApplyStatus().equals(FeeApplyStatusEnum.CREATE.getCode()) && !admFeeApplyVO.getApplyStatus().equals(FeeApplyStatusEnum.REJECTED.getCode())) {
                throw TwException.error("", "仅支持新建或已拒绝状态修改");
            }
        }
        return admFeeApplyVO;
    }

    @Override
    public PagingVO<AdmFeeApplyVO> queryPaging(AdmFeeApplyQuery query) {
        return admFeeApplyDAO.queryPaging(query);
    }

    @Override
    public List<AdmFeeApplyVO> queryListDynamic(AdmFeeApplyQuery query) {
        List<AdmFeeApplyVO> admFeeApplyVOS = admFeeApplyDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(admFeeApplyVOS)) {
            admFeeApplyVOS.forEach(
                    vo -> {
                        vo.setOuName(cacheUtil.getCompanyNameByBookId(vo.getOuId()));
                    }
            );
        }
        return admFeeApplyVOS;
    }

    @Override
    public AdmFeeApplyVO queryByKey(Long key) {
        AdmFeeApplyVO admFeeApplyVO = admFeeApplyDAO.queryByKey(key);
        AdmFeeApplyDetailQuery queryDetail = new AdmFeeApplyDetailQuery();
        queryDetail.setApplyId(key);
        List<AdmFeeApplyDetailVO> admFeeApplyDetailVOS = admFeeApplyDetailService.queryListDynamic(queryDetail);
        String companyName = cacheUtil.getCompanyNameByBookId(admFeeApplyVO.getOuId());
        admFeeApplyVO.setOuName(companyName);
        admFeeApplyVO.setCustName(cacheUtil.getCompanyNameByBookId(admFeeApplyVO.getCustId()));
        admFeeApplyVO.setDetailVOs(admFeeApplyDetailVOS);

        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(admFeeApplyVO.getApplyResId());
        String applyResLevel = "";
        if (employee != null) {
            applyResLevel = employee.getExtString1();
        }
        admFeeApplyVO.setApplyResLevel(applyResLevel);

        return admFeeApplyVO;
    }

    //
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public AdmFeeApplyVO update(AdmFeeApplyPayload payload) {
//        AdmFeeApplyDO entity = admFeeApplyRepo.findById(payload.getId()).orElseGet(AdmFeeApplyDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        AdmFeeApplyDO entityDo = AdmFeeApplyConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
//        return AdmFeeApplyConvert.INSTANCE.toVo(admFeeApplyRepo.save(entity));
//    }
//
    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AdmFeeApplyPayload payload) {
        return admFeeApplyDAO.updateByKeyDynamic(payload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<AdmFeeApplyVO> admFeeApplyVOS = admFeeApplyDAO.queryByKeys(keys);
            if (!ObjectUtils.isEmpty(admFeeApplyVOS)) {
                //   Long loginUserId = GlobalUtil.getLoginUserId();
                admFeeApplyVOS.forEach(vo -> {
                    if (!vo.getApplyStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                        throw TwException.error("", "仅支持新建状态的删除");
                    }
                    try {
                        //删除流程
                        if (StringUtils.hasText(vo.getProcInstId())) {
                            workflowUtil.deleteProcess(DeleteProcessPayload.of(vo.getProcInstId(), ""));
                        }
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                //删除出差数据
                admFeeApplyDAO.deleteSoft(keys);
                //删除明细数据
                admFeeApplyDetailService.deleteSoftByApplyId(keys);
            }
        }
    }

    @Override
    public void processStatusChange(ProcessStatusChangePayload payload) {
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        //根据业务key查询当前业务对象
        AdmFeeApplyVO admFeeApplyVO = admFeeApplyDAO.queryByKey(Long.valueOf(businessKey));
        if (admFeeApplyVO != null) {
            AdmFeeApplyPayload busitripApplyPayload = new AdmFeeApplyPayload();
            busitripApplyPayload.setId(Long.parseLong(businessKey));
            busitripApplyPayload.setApprStatus(procInstStatus.name());
            switch (procInstStatus) {
                case NOTSUBMIT://创建人提交节点
                    //taskAuthorizedPayload.setApprStatus(procInstStatus.name());
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                case INTERRUPT://中断（删除工作流，初始化单据，管理员操作）
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    //  taskAuthorizedPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    busitripApplyPayload.setProcInstId(null);
                    busitripApplyPayload.setNullFields(List.of("procInstId"));
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                case INVALID://作废 先删除流程再删除单据
                    //一般情况将单据状态变成"作废" ，或直接删除单据
                    //一般情况将单据状态变成"新建",并且将单据上的"流程实例状态"，"流程实例ID"清成null
                    busitripApplyPayload.setDeleteFlag(1);
                    //taskAuthorizedPayload.setApprStatus(ProjectStatusEnum.CREATE.getCode());
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                case REJECTED://审批人拒绝，回到第一个节点
                    //将单据状态变为新建状态
                    //  taskAuthorizedPayload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.CREATE.getCode());
                    break;
                case APPROVED:
                    //   taskAuthorizedPayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
//                    busitripApplyPayload.setProcInstId(null);
//                    busitripApplyPayload.setNullFields(List.of("procInstId"));
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.APPROVED.getCode());
                    //要知会总裁和CFO
                        String content = "特殊费用申请名称为[" + admFeeApplyVO.getApplyName() + "] 的流程已完成审批，请知悉";
                        String title = "特殊费用申请结果提醒";
                        sendMessage(Long.valueOf(businessKey), title, content);
                    break;
                case APPROVING:
                    busitripApplyPayload.setApplyStatus(FeeApplyStatusEnum.APPLYING.getCode());
                    break;
            }
            admFeeApplyDAO.updateByKeyDynamic(busitripApplyPayload);

        }
    }

    public void sendMessage(Long objectId, String messageTitle, String content) {
        PrdMessageConfigPayload ado = new PrdMessageConfigPayload();
        ado.setObjectId(objectId);
        ado.setMessageTitle(messageTitle);
        ado.setMessageType(2);
        ado.setContentBigType("businessMessage");
        ado.setContentType(MessageNoticeTypeEnum.systemMessage.getCode());
        ado.setMessageTag("important");
        ado.setIsEnable(0);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(3);
        ado.setMessageContent(content);
        List<Long> list = new ArrayList();
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
        list.addAll(roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
        if (!CollectionUtils.isEmpty(list)) {
            String noticeSource = list.stream().map(p -> p.toString()).collect(Collectors.joining(","));
            ado.setNoticeSource(noticeSource);
            //保存信息
            messageConfigService.insert(ado);
        }

    }

    @Override
    public AdmFeeApplyVO queryOneByKey(Long key) {
        return admFeeApplyDAO.queryByKey(key);
    }

    @Override
    public void unbindReim(Long reimId) {
        admFeeApplyDAO.unbindReim(reimId);
    }
}
