package com.elitesland.tw.tw5.server.prd.app.controller;

import com.elitesland.tw.tw5.api.prd.app.payload.AppVersionPayload;
import com.elitesland.tw.tw5.api.prd.app.query.AppVersionQuery;
import com.elitesland.tw.tw5.api.prd.app.service.AppVersionService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * APP版本管理
 *
 * @author duwh
 * @date 2023-02-23
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/app/appVersion")
@Slf4j
public class AppVersionController {

    private final AppVersionService appVersionService;

    /**
     * 新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    public TwOutputUtil insert(@RequestBody AppVersionPayload payload) {
        return TwOutputUtil.ok(appVersionService.insert(payload));
    }

    /**
     * 更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    public TwOutputUtil update(@RequestBody AppVersionPayload payload) {
        return TwOutputUtil.ok(appVersionService.update(payload));
    }

    /**
     * 主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(appVersionService.queryByKey(key));
    }

    /**
     * 分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    public TwOutputUtil paging(AppVersionQuery query) {
        return TwOutputUtil.ok(appVersionService.paging(query));
    }

    /**
     * 查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    public TwOutputUtil queryList(AppVersionQuery query) {
        return TwOutputUtil.ok(appVersionService.queryList(query));
    }


    /**
     * 获得当前版本
     *
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/getCurrentVersion")
    // @UdcNameClass
    public TwOutputUtil getCurrentVersion() {
        return TwOutputUtil.ok(appVersionService.getCurrentVersion());
    }

    /**
     * 删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys) {
        appVersionService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
