package com.elitesland.tw.tw5.server.prd.borrow.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 借款核销
 *
 * @author wangly
 * @date 2024-07-15
 */
@Entity
@Table(name = "borrow_write_off", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "borrow_write_off", comment = "借款核销")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BorrowWriteOffDO extends BaseModel implements Serializable  {
    /** 借款ID */
    @Comment("借款ID")
    @Column()
    private Long borrowId;
    /** 核销关联单据ID */
    @Comment("核销关联单据ID")
    @Column()
    private Long reimId;
    /** 核销单据号 */
    @Comment("核销单据号")
    @Column()
    private String reimNo;
    /** 核销类型 [BORROW_MONEY:WRITE_OFF_TYPE] */
    @Comment("核销类型 [BORROW_MONEY:WRITE_OFF_TYPE]")
    @Column()
    private String writeOffType;
    /** 核销单据名称 */
    @Comment("核销单据名称")
    @Column()
    private String writeOffName;
    /** 核销人ID */
    @Comment("核销人ID")
    @Column()
    private Long writeOffUserId;
    /** 核销日期 */
    @Comment("核销日期")
    @Column()
    private LocalDate writeOffDate;
    /** 核销金额 */
    @Comment("核销金额")
    @Column()
    private BigDecimal writeOffAmt;
    /** 扩展字段1 */
    @Comment("扩展字段1")
    @Column()
    private String ext1;
    /** 扩展字段2 */
    @Comment("扩展字段2")
    @Column()
    private String ext2;
    /** 扩展字段3 */
    @Comment("扩展字段3")
    @Column()
    private String ext3;
    /** 扩展字4 */
    @Comment("扩展字4")
    @Column()
    private String ext4;
    /** 扩展字5 */
    @Comment("扩展字5")
    @Column()
    private String ext5;

    public void copy(BorrowWriteOffDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
