package com.elitesland.tw.tw5.server.prd.budget.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "budget_change_tmp", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "budget_change_tmp", comment = "预算变更信息临时表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BudgetChangeTmpDO extends BaseModel {

    @Comment("预算id")
    @Column
    private Long budgetId;

    @Comment("项目id")
    @Column
    private Long projectId;

    @Comment("变更金额")
    @Column
    private BigDecimal deleteAmt;

    @Comment("变更当量")
    @Column
    private BigDecimal deleteEqva;

    @Comment("申请时间")
    @Column
    private LocalDateTime applyTime;

}
