package com.elitesland.tw.tw5.server.prd.cal.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalTaskSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.permission.annotation.FunctionDetail;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionDomain;
import com.elitesland.tw.tw5.server.common.permission.annotation.PermissionFunction;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionCodeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionDomainEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;

/**
 * 任务包结算管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Api(tags = "任务包结算管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/cal/calTaskSettle")
@Slf4j
@PermissionDomain(domain = PermissionDomainEnum.TASK_SETTLE)
public class CalTaskSettleController {

    private final CalTaskSettleService calTaskSettleService;

    /**
     * 任务包结算管理- 新增或修改
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("任务包结算管理- 新增或修改")
    public TwOutputUtil<CalTaskSettleVO> insertOrUpdate(@RequestBody CalTaskSettlePayload payload) {
        return TwOutputUtil.ok(calTaskSettleService.insertOrUpdate(payload));
    }

    /**
     * 任务包结算管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/byKey/{key}")
    @UdcNameClass
    @ApiOperation("任务包结算管理-主键查询")
    public TwOutputUtil<CalTaskSettleVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(calTaskSettleService.queryByKey(key));
    }

    /**
     * 任务包结算管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @PostMapping("/paging")
    @UdcNameClass
    @ApiOperation("任务包结算管理-分页")
    @PermissionFunction(functions = {
            @FunctionDetail(functionCode = FunctionCodeEnum.TASK_SETTLE_PAGE, type = FunctionTypeEnum.TAB)
    }, fieldPermission = true, permissionType = PermissionTypeEnum.DATA_PERMISSION)
    public TwOutputUtil<PagingVO<CalTaskSettleVO>> paging(@RequestBody CalTaskSettleQuery query) {
        return TwOutputUtil.ok(calTaskSettleService.queryPaging(query));
    }

    /**
     * 任务包结算管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("updateFlow")
    @ApiOperation("任务包结算管理-更新（流程中数据修改）")
    public TwOutputUtil<Long> updateFlow(@RequestBody CalTaskSettlePayload payload) {
        return TwOutputUtil.ok(calTaskSettleService.updateFlow(payload));
    }

    /**
     * 任务包结算管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("任务包结算管理-查询列表")
    public TwOutputUtil<List<CalTaskSettleVO>> queryList(CalTaskSettleQuery query) {
        return TwOutputUtil.ok(calTaskSettleService.queryListDynamic(query));
    }
    //
//    /**
//     * 任务包结算管理-更新
//     *
//     * @param payload 有效载荷
//     * @return {@link TwOutputUtil}
//     */
//    @PutMapping
//    @ApiOperation("任务包结算管理-更新")
//    public TwOutputUtil<CalTaskSettleVO> update(@RequestBody CalTaskSettlePayload payload) {
//        return TwOutputUtil.ok(calTaskSettleService.update(payload));
//    }
//


//

//

    /**
     * 任务包结算管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("任务包结算管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        calTaskSettleService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 任务包结算管理-调整结算期间
     *
     * @param keys 主键id
     * @return result
     */
    @GetMapping("/updateSettleDate")
    @ApiOperation("任务包结算管理-调整结算期间")
    public TwOutputUtil updateSettleDate(Long[] keys, @DateTimeFormat(pattern = "yyyy-MM-dd") LocalDate settleDate) {
        calTaskSettleService.updateSettleDate(Arrays.asList(keys), settleDate);
        return TwOutputUtil.ok();
    }

    /**
     * 任务包结算管理-提现操作
     *
     * @param payload 提现数据
     * @return result
     */
    @GetMapping("/taskSettleWithdraw")
    @ApiOperation("任务包结算管理-提现操作")
    public TwOutputUtil taskSettleWithdraw(CalTaskSettleWithdrawPayload payload) {
        calTaskSettleService.taskSettleWithdraw(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 任务包结算管理-提现操作
     *
     * @param payload 提现数据
     * @return result
     */
    @PostMapping("/taskSettleWithdrawPost")
    @ApiOperation("任务包结算管理-提现操作")
    public TwOutputUtil taskSettleWithdrawPost(@RequestBody CalTaskSettleWithdrawPayload payload) {
        calTaskSettleService.taskSettleWithdraw(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 任务包结算管理-反向结算（仅管理员操作）
     *
     * @param taskNo  任务编号
     * @param eqvaNum 反向结算当量（负数）
     * @param message 撤回说明
     * @return
     */
    @GetMapping("/reverseTaskSettle")
    @ApiOperation("任务包结算管理-反向结算（仅管理员操作）")
    public TwOutputUtil reverseTaskSettle(String taskNo, BigDecimal eqvaNum, String message) {
        calTaskSettleService.reverseTaskSettle(taskNo, eqvaNum, message);
        return TwOutputUtil.ok();
    }

}

