package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 任务包
 *
 * @author carl
 * @date 2023-11-15
 */
@Entity
@Table(name = "cal_task_settle_detail", indexes = {
        @Index(name = "settle_index", columnList = "settle_id"),
        @Index(name = "task_index", columnList = "task_id")
})
@org.hibernate.annotations.Table(appliesTo = "cal_task_settle_detail", comment = "任务包")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalTaskSettleDetailDO extends BaseModel implements Serializable {
    /**
     * 结算单id
     */
    @Comment("结算单id")
    @Column(name = "settle_id")
    private Long settleId;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projId;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column(name = "task_id")
    private Long taskId;

    /**
     * 任务名称（冗余）
     */
    @Comment("任务名称（冗余）")
    @Column()
    private String taskName;
    /**
     * 任务状态（冗余）
     */
    @Comment("任务状态")
    @Column()
    private String taskStatus;
    /**
     * 计划开始日期（冗余）
     */
    @Comment("计划开始日期（冗余）")
    @Column()
    private LocalDate planStartDate;
    /**
     * 计划结束日期（冗余）
     */
    @Comment("计划结束日期（冗余）")
    @Column()
    private LocalDate planEndDate;
    /**
     * 派发当量
     */
    @Comment("派发当量")
    @Column()
    private BigDecimal distedEqva;
    /**
     * 已结算当量
     */
    @Comment("已结算当量")
    @Column(precision = 12, scale = 4)
    private BigDecimal settledEqva;
    /**
     * 申请结算当量数
     */
    @Comment("申请结算当量数")
    @Column(precision = 12, scale = 4)
    private BigDecimal applySettleEqva;
    /**
     * 快照完工百分比
     */
    @Comment("快照完工百分比")
    @Column()
    private BigDecimal ssCompPercent;
    /**
     * 申请结算百分比
     */
    @Comment("申请结算百分比")
    @Column()
    private BigDecimal applySettlePercent;
    /**
     * 申请结算总额
     */
    @Comment("申请结算总额")
    @Column()
    private BigDecimal applySettleAmt;
    /**
     * 实际结算当量数
     */
    @Comment("实际结算当量数")
    @Column()
    private BigDecimal approveSettleEqva;
    /**
     * 实际结算总额
     */
    @Comment("实际结算总额")
    @Column()
    private BigDecimal approveSettleAmt;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 结算说明
     */
    @Comment("结算说明")
    @Column()
    private String settleDesc;

    public void copy(CalTaskSettleDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
