package com.elitesland.tw.tw5.server.prd.cal.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 泛用当量结算单管理
 *
 * @author carl
 * @date 2023-11-15
 */
@Entity
@Table(name = "cal_wide_settle", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "cal_wide_settle", comment = "泛用当量结算单管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CalWideSettleDO extends BaseModel implements Serializable {
    /**
     * 结算单号
     */
    @Comment("结算单号")
    @Column()
    private String settleNo;
    /**
     * 结算状态
     */
    @Comment("结算状态")
    @Column()
    private String settleStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 申请资源id
     */
    @Comment("申请资源id")
    @Column()
    private Long applyResId;
    /**
     * 流程实例id
     */
    @Comment("流程实例id")
    @Column()
    private String procInstId;
    /**
     * 结算类型（项目立项，项目结项。。。）
     */
    @Comment("结算类型（项目立项，项目结项。。。）")
    @Column()
    private String settleType;
    /**
     * 结算日期
     */
    @Comment("结算日期")
    @Column()
    private LocalDate settleDate;
    /**
     * 财务期间id
     */
    @Comment("财务期间id")
    @Column()
    private Long finPeriodId;
    /**
     * 支出核算主题类型
     */
    @Comment("支出核算主题类型")
    @Column()
    private String fromSourceType;
    /**
     * 支出核算主题id
     */
    @Comment("支出核算主题id")
    @Column()
    private Long fromSourceId;
    /**
     * 支出核算主题名称（冗余）
     */
    @Comment("支出核算主题名称（冗余）")
    @Column()
    private String fromSourceName;
    /**
     * 收入核算主题类型
     */
    @Comment("收入核算主题类型")
    @Column()
    private String toSourceType;
    /**
     * 收入核算主题id
     */
    @Comment("收入核算主题id")
    @Column()
    private Long toSourceId;
    /**
     * 收入核算主题名称（冗余）
     */
    @Comment("收入核算主题名称（冗余）")
    @Column()
    private String toSourceName;
    /**
     * 申请结算当量数
     */
    @Comment("申请结算当量数")
    @Column()
    private BigDecimal applySettleEqva;
    /**
     * 申请结算总额
     */
    @Comment("申请结算总额")
    @Column()
    private BigDecimal applySettleAmt;
    /**
     * 结算单价
     */
    @Comment("结算单价")
    @Column()
    private BigDecimal settlePrice;
    /**
     * 交易凭证文件code
     */
    @Comment("交易凭证文件code")
    @Column()
    private String fileCodes;

    public void copy(CalWideSettleDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
