package com.elitesland.tw.tw5.server.prd.copartner.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 合伙人绩效自述表
 *
 * @author carl
 * @date 2024-06-24
 */
@Entity
@Table(name = "performance_readme_user_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "performance_readme_user_detail", comment = "合伙人绩效自述表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PerformanceReadmeUserDetailDO extends BaseModel implements Serializable {
    /**
     * 配置主键
     */
    @Comment("配置主键")
    @Column()
    private Long configId;
    /**
     * 配置详情主键
     */
    @Comment("配置详情主键")
    @Column()
    private Long configDetailId;
    /**
     * 配置员工详情主键
     */
    @Comment("配置员工详情主键")
    @Column()
    private Long configUserId;
    /**
     * 员工主键
     */
    @Comment("员工主键")
    @Column()
    private Long userId;
    /**
     * 合同id
     */
    @Comment("合同id")
    @Column()
    private Long contractId;
    /**
     * 合同名称
     */
    @Comment("合同名称")
    @Column()
    private String contractName;
    /**
     * 合同类型
     */
    @Comment("合同类型")
    @Column()
    private String contractType;
    /**
     * 商机id
     */
    @Comment("商机id")
    @Column()
    private Long oppoId;
    /**
     * 商机名称
     */
    @Comment("商机名称")
    @Column()
    private String oppoName;
    /**
     * 业务种类
     */
    @Comment("业务种类")
    @Column()
    private String businessType;
    /**
     * 签单金额
     */
    @Comment("签单金额")
    @Column()
    private BigDecimal amount;
    /**
     * 签单金额（不含税）
     */
    @Comment("签单金额（不含税）")
    @Column()
    private BigDecimal amountNoTax;
    /**
     * 签单销售人员id
     */
    @Comment("签单销售人员id")
    @Column()
    private Long saleUserId;
    /**
     * 工时总人天
     */
    @Comment("工时总人天")
    @Column()
    private BigDecimal totalDays;
    /**
     * 工时售前人天
     */
    @Comment("工时售前人天")
    @Column()
    private BigDecimal preSaleDays;
    /**
     * 售前支持角色
     */
    @Comment("售前支持角色")
    @Column()
    private String preSaleRole;
    /**
     * 工时商务人天
     */
    @Comment("工时商务人天")
    @Column()
    private BigDecimal businessDays;
    /**
     * 商务支持角色
     */
    @Comment("商务支持角色")
    @Column()
    private String businessRole;
    /**
     * 工时交付人天
     */
    @Comment("工时交付人天")
    @Column()
    private BigDecimal deliDays;
    /**
     * 交付支持角色
     */
    @Comment("交付支持角色")
    @Column()
    private String deliRole;
    /**
     * 分配比例
     */
    @Comment("分配比例")
    @Column()
    private String ratio;
    /**
     * 分配金额
     */
    @Comment("分配金额")
    @Column()
    private BigDecimal amt;
    /**
     * 商机状态
     */
    @Comment("商机状态")
    @Column()
    private String oppoStatus;
    /**
     * 任务名称
     */
    @Comment("任务名称")
    @Column()
    private String taskName;
    /**
     * 任务类型
     */
    @Comment("任务类型")
    @Column()
    private String taskType;
    /**
     * 受惠事业部
     */
    @Comment("受惠事业部")
    @Column()
    private Long incomeBuId;
    /**
     * 任务角色
     */
    @Comment("任务角色")
    @Column()
    private String taskRole;
    /**
     * 任务描述
     */
    @Comment("任务描述")
    @Column()
    private String taskDetail;
    /**
     * 任务收益描述
     */
    @Comment("任务收益描述")
    @Column()
    private String taskIncomeDesc;
    /**
     * 自动还是手动创建
     */
    @Comment("自动还是手动创建")
    @Column(columnDefinition = "tinyint DEFAULT 0")
    private Integer createFlag;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column()
    private Long projectId;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projectName;
    /**
     * 拓展字符串1
     */
    @Comment("拓展字符串1")
    @Column()
    private String extStr1;
    /**
     * 拓展字符串2
     */
    @Comment("拓展字符串2")
    @Column()
    private String extStr2;
    /**
     * 拓展字符串3
     */
    @Comment("拓展字符串3")
    @Column()
    private String extStr3;
    /**
     * 拓展字符串4
     */
    @Comment("拓展字符串4")
    @Column()
    private String extStr4;
    /**
     * 拓展字符串5
     */
    @Comment("拓展字符串5")
    @Column()
    private String extStr5;
    /**
     * 拓展数字1
     */
    @Comment("拓展数字1")
    @Column()
    private BigDecimal extNumber1;
    /**
     * 拓展数字2
     */
    @Comment("拓展数字2")
    @Column()
    private BigDecimal extNumber2;
    /**
     * 拓展数字3
     */
    @Comment("拓展数字3")
    @Column()
    private BigDecimal extNumber3;
    /**
     * 拓展主键1
     */
    @Comment("拓展主键1")
    @Column()
    private Long extKey1;
    /**
     * 拓展主键2
     */
    @Comment("拓展主键2")
    @Column()
    private Long extKey2;
    /**
     * 拓展主键3
     */
    @Comment("拓展主键3")
    @Column()
    private Long extKey3;

    public void copy(PerformanceReadmeUserDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
