package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActDynamicPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActReportPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;

/**
 * 市场活动管理
 *
 * @author carl.wang
 * @date
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm")
@Slf4j
public class CrmActActivityController {

    private final CrmActActivityService service;

    /**
     * 新建
     *
     * @param payload po类
     * @return result
     */
    @PostMapping("/act/insert")
    //@GlobalTransactional
    public TwOutputUtil insert(CrmActActivityPayload payload) {
        CrmActActivityVO vo = service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    /**
     * 修改
     *
     * @param payload po类
     * @return result
     */
    //@GlobalTransactional
    @PutMapping("/act/update")
    public TwOutputUtil update(@RequestBody CrmActActivityPayload payload) {
        service.update(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/act/paging")
    public TwOutputUtil paging(CrmActActivityQuery query) {
        return TwOutputUtil.ok(service.paging(query));
    }

    /**
     * 列表查询
     *
     * @param planId 计划id
     * @return result
     */
    @GetMapping("/act/queryList")
    public TwOutputUtil queryList(Long planId) {
        return TwOutputUtil.ok(service.queryList(planId));
    }

    /**
     * 详情查询
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/act/queryByKey/{id}")
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmActActivityVO vo = service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }


    /**
     * 查询跟进记录
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/act/queryDynamicByKey/{id}")
    public TwOutputUtil queryDynamicByKey(@PathVariable Long id) {
        List<CrmActDynamicVO> vos = service.queryDynamicByKey(id);
        return TwOutputUtil.ok(vos);
    }

    /**
     * 查询团队成员
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/act/queryMembersByKey/{id}")
    public TwOutputUtil queryMembersByKey(@PathVariable Long id) {
        List<PrjProjectMemberVO> vos = service.queryMembersByKey(id);
        return TwOutputUtil.ok(vos);
    }


    /**
     * 批量导出活动excel
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/act/downloadActivitys")
    public void downloadActivitys(HttpServletResponse response, CrmActActivityQuery query) {
        service.downloadActivitys(response, query);
    }

    /**
     * 更改负责人
     *
     * @param key       活动主键
     * @param userId    变更后的负责人userid
     * @param opeStatus 操作状态 0:直接删除，1：改为成员
     * @return result
     */
    @GetMapping("/act/changeManger")
    public TwOutputUtil changeManger(Long key, Long userId, Integer opeStatus) {
        service.changeManger(key, userId, opeStatus);
        return TwOutputUtil.ok();
    }

    /**
     * 修改激活暂挂状态
     *
     * @param key 活动主键
     * @return result
     */
    @GetMapping("/act/changeLockStatus")
    public TwOutputUtil changeLockStatus(Long key) {
        service.changeLockStatus(key);
        return TwOutputUtil.ok();
    }

    /**
     * 添加成员
     *
     * @param actId   活动Id
     * @param userIds 添加成员userid
     * @return result
     */
    @GetMapping("/act/addMember")
    public TwOutputUtil addMember(Long actId, Long[] userIds) {
        List<PrjProjectMemberVO> memberVOS = service.addMember(actId, Arrays.asList(userIds));
        return TwOutputUtil.ok(memberVOS);
    }

    /**
     * 删除成员
     *
     * @param actId 活动主键id
     * @param keys  成员主键id
     * @return result
     */
    @GetMapping("/act/deleteMember")
    public TwOutputUtil deleteMember(Long actId, Long[] keys) {
        service.deleteMember(actId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 添加跟进动态
     *
     * @param payload 跟进动态类
     * @return result
     */
    @PostMapping("/act/addDynamic")
    public TwOutputUtil addDynamic(CrmActDynamicPayload payload) {
        return TwOutputUtil.ok(service.addDynamic(payload));
    }

    /**
     * 修改活动动态跟进
     *
     * @param payload 跟进动态类
     * @return result
     */
    @PostMapping("/act/updateDynamic")
    public TwOutputUtil updateDynamic(CrmActDynamicPayload payload) {
        return TwOutputUtil.ok(service.updateDynamic(payload));
    }

    /**
     * 跟进动态详情查询
     *
     * @param id 主键
     * @return result
     */
    @GetMapping("/act/queryActDynamicDetail/{id}")
    public TwOutputUtil queryActDynamicDetail(@PathVariable Long id) {
        return TwOutputUtil.ok(service.queryActDynamicDetail(id));
    }

    /**
     * 活动关闭
     *
     * @param key         活动主键
     * @param closeReson  关闭原因 act_exception：异常终止，act_end:活动结束
     * @param clsoeRemark 关闭备注
     * @return result
     */
    @GetMapping("/act/closeActivity")
    public TwOutputUtil closeActivity(Long key, String closeReson, String clsoeRemark) {
        service.closeActivity(key, closeReson, clsoeRemark);
        return TwOutputUtil.ok();
    }

    /**
     * 获取汇报数据
     *
     * @param id 市场活动主键
     * @return result
     */
    @GetMapping("/act/queryActReportData/{id}")
    public TwOutputUtil queryActReportData(@PathVariable Long id) {
        return TwOutputUtil.ok(service.queryActReportData(id));
    }

    /**
     * 新增活动情况汇报
     *
     * @param payload 跟进动态类
     * @return result
     */
    @PostMapping("/act/addReport")
    public TwOutputUtil addReport(CrmActReportPayload payload) {
        return TwOutputUtil.ok(service.addReport(payload));
    }

    /**
     * 获取汇报数据列表
     *
     * @param actId      市场活动主键
     * @param reportType 汇报数据类型
     * @return result
     */
    @GetMapping("/act/queryActReportList")
    public TwOutputUtil queryActReportList(Long actId, Integer reportType) {
        return TwOutputUtil.ok(service.queryActReportList(actId, reportType));
    }

    /**
     * 获取汇报数据列表
     *
     * @param reportId   市场活动主键
     * @param reportType 汇报数据类型
     * @return result
     */
    @GetMapping("/act/queryActReportListByReportId")
    public TwOutputUtil queryActReportListByReportId(Long reportId, Integer reportType) {
        return TwOutputUtil.ok(service.queryReportByKey(reportId, reportType));
    }

    /**
     * 获取汇报数据详情
     *
     * @param id 汇报数据主键
     * @return result
     */
    @GetMapping("/act/queryActReportDetail/{id}")
    public TwOutputUtil queryActReportDetail(@PathVariable Long id) {
        return TwOutputUtil.ok(service.queryActReportDetail(id));
    }


    /**
     * 查询变更历史
     */
    @GetMapping("/act/{activityId}")
    public TwOutputUtil changeLogList(@PathVariable Long activityId) {
        return TwOutputUtil.ok(service.changeLogList(activityId));
    }

    /**
     * 打开变更模式，返回结果
     *
     * @param activityId 计划id
     * @return
     */
    @GetMapping("/act/changeModeData/{activityId}")
    public TwOutputUtil getChangeModeData(@PathVariable Long activityId) {
        return TwOutputUtil.ok(service.changeLogDetailByActivityId(activityId));
    }


    /**
     * 未发布公告的活动分页查询
     *
     * @param query 查询条件
     * @return result
     */
    @GetMapping("/act/unReleasedPaging")
    public TwOutputUtil queryPagingUnReleased(CrmActActivityQuery query) {
        return TwOutputUtil.ok(service.queryPagingUnReleased(query));
    }

    /**
     * 不发布公告
     *
     * @param id 活动id
     * @return result
     */
    @GetMapping("/act/refuseRelease/{id}")
    public TwOutputUtil refuseRelease(@PathVariable Long id) {
        service.refuseRelease(id);
        return TwOutputUtil.ok();
    }

    /**
     * @return result
     */
    @GetMapping("/act/test")
    public TwOutputUtil test() {
        service.activityUnReleaseJobHandler();
        return TwOutputUtil.ok();
    }


}
