package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;

import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 礼品单
 *
 * @author xxb
 * @date 2023-08-31
 */
@Entity
@Table(name = "crm_gift_list", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_gift_list", comment = "礼品单")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmGiftListDO extends BaseModel implements Serializable {
    /**
     * 礼品单编号
     */
    @Comment("礼品单编号")
    @Column()
    private String giftNo;
    /**
     * 申请用户ID
     */
    @ApiModelProperty("申请用户ID")
    private Long applyUserId;
    @Comment("申请人bu")
    @Column()
    private Long applyUserBuId;
    @Comment("创建人bu")
    @Column()
    private Long createUserBuId;
    /**
     * 礼品类型 一级
     */
    @Comment("礼品类型 一级")
    @Column()
    private String giftType1;
    /**
     * 礼品类型 二级
     */
    @Comment("礼品类型 二级")
    @Column()
    private String giftType2;
    /**
     * 特殊申请用户标志
     */
    @Comment("特殊申请用户标志")
    @Column()
    private Integer specialUsersFlag;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 流程审批状态
     */
    @Comment("流程审批状态")
    @Column()
    private ProcInstStatus procInstStatus;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvedTime;

    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;

    @Comment("申请状态")
    @Column()
    private String applyStatus;

    public void copy(CrmGiftListDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
