package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Author carl.wang
 * @Description 市场计划表
 * @Date
 **/
@Entity
@Table(name = "crm_opportunity_partner", indexes = {
        @Index(name = "oppo_index", columnList = "oppo_id"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_partner", comment = "商机合作伙伴表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityPartnerDO extends BaseModel {

    @Comment("商机ID")
    @Column(name = "oppo_id", nullable = false)
    private Long oppoId;

    @Comment("tw4.0商机合作伙伴ID")
    @Column(name = "partner_id_v4")
    private Long partnerIdV4;

    @Comment("合作伙伴名称")
    @Column()
    private String partnerName;

    @Comment("联系人")
    @Column()
    private String partnerContact;

    @Comment("联系人邮箱")
    @Column()
    private String contactEmail;

    @Comment("联系人电话")
    @Column()
    private String contactPhone;

    @Comment("合作事项")
    @Column()
    private String coopDesc;

    @Comment("合作利益分配")
    @Column()
    private String profitShare;

}
