package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 商机review
 *
 * @author zoey
 * @date 2023-11-01
 */
@Entity
@Table(name = "crm_opportunity_review", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_opportunity_review", comment = "商机review")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOpportunityReviewDO extends BaseModel implements Serializable  {
    @Comment("商机ID")
    @Column(name = "oppo_id", nullable = false)
    private Long oppoId;
    /** 风险类型 */
    @Comment("风险类型")
    @Column()
    private String riskType;
    /** 风险点描述 */
    @Comment("风险点描述")
    @Column()
    private String riskDesc;
    /** 应对计划 */
    @Comment("应对计划")
    @Column()
    private String answerPlan;
    /** 计划结束时间 */
    @Comment("计划结束时间")
    @Column()
    private LocalDate planEndTime;
    /** 负责人 */
    @Comment("负责人")
    @Column()
    private Long directorUserId;
    /** 已完成、未完成、进行中 */
    @Comment("已完成、未完成、进行中")
    @Column()
    private String finishState;

    public void copy(CrmOpportunityReviewDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
