package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOppoConversionRatePayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOppoConversionRateService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMeasureService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityScoreConfigService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoConversionRateVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOppoDataSourceFieldsVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMeasureVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityScoreConfigVO;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOppoDataSourceFieldsConvert;
import com.elitesland.tw.tw5.server.prd.crm.repo.CmfOppoDataSourceFieldsRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 商机成单率配置
 *
 * @author likunpeng
 * @date 2023/11/3
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOppoConversionRateServiceImpl extends BaseServiceImpl implements CrmOppoConversionRateService {

    private final CrmOpportunityMeasureService crmOpportunityMeasureService;
    private final CrmOpportunityScoreConfigService crmOpportunityScoreConfigService;
    private final CmfOppoDataSourceFieldsRepo cmfOppoDataSourceFieldsRepo;

    @Override
    @Transactional
    public CrmOppoConversionRateVO insertOrUpdate(CrmOppoConversionRatePayload payload) {
        // 保存计算指标
        List<CrmOpportunityMeasureVO> crmOpportunityMeasureVOS = crmOpportunityMeasureService.insertOrUpdate(payload.getCrmOpportunityMeasurePayloads());
        // 删除计算指标
        crmOpportunityMeasureService.deleteSoft(payload.getMeasureDeleteKeys());
        // 保存商机成单率分值配置
        List<CrmOpportunityScoreConfigVO> crmOpportunityScoreConfigVOS = crmOpportunityScoreConfigService.insertOrUpdate(payload.getScoreConfigPayloads());
        CrmOppoConversionRateVO crmOppoConversionRateVO = new CrmOppoConversionRateVO();
        crmOppoConversionRateVO.setCrmOpportunityMeasureVOS(crmOpportunityMeasureVOS);
        crmOppoConversionRateVO.setScoreConfigVOS(crmOpportunityScoreConfigVOS);
        return crmOppoConversionRateVO;
    }

    @Override
    public CrmOppoConversionRateVO queryConfig() {
        CrmOppoConversionRateVO resultVO = new CrmOppoConversionRateVO();
        // 商机成单率计算指标
        List<CrmOpportunityMeasureVO> crmOpportunityMeasureVOS = crmOpportunityMeasureService.queryAll();
        resultVO.setCrmOpportunityMeasureVOS(crmOpportunityMeasureVOS);
        // 商机成单率分值配置
        List<CrmOpportunityScoreConfigVO> crmOpportunityScoreConfigVOS = crmOpportunityScoreConfigService.queryAll();
        resultVO.setScoreConfigVOS(crmOpportunityScoreConfigVOS);
        return resultVO;
    }

    @Override
    public List<CrmOppoDataSourceFieldsVO> queryDataSourceFields() {
        return CrmOppoDataSourceFieldsConvert.INSTANCE.toVoList(cmfOppoDataSourceFieldsRepo.findAll());
    }

    @Override
    public CrmOppoDataSourceFieldsVO queryDataSourceFieldsById(Long fieldId) {
        return CrmOppoDataSourceFieldsConvert.INSTANCE.toVo(cmfOppoDataSourceFieldsRepo.findById(fieldId).orElse(null));
    }
}
