package com.elitesland.tw.tw5.server.prd.crm.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMilestonePlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityMilestonePlanService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMilestonePlanVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityMilestonePlanConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityMilestonePlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityMilestonePlanDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMilestonePlanRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * 里程碑计划
 *
 * @author zoey
 * @date 2023-11-01
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmOpportunityMilestonePlanServiceImpl extends BaseServiceImpl implements CrmOpportunityMilestonePlanService {

    private final CrmOpportunityMilestonePlanRepo crmOpportunityMilestonePlanRepo;
    private final CrmOpportunityMilestonePlanDAO crmOpportunityMilestonePlanDAO;
    private final CrmOpportunityDAO crmOpportunityDAO;
    private final PrdMessageConfigService messageConfigService;
    private final CacheUtil cacheUtil;
    private final UdcUtil udcUtil;

    @Override
    public PagingVO<CrmOpportunityMilestonePlanVO> queryPaging(CrmOpportunityMilestonePlanQuery query) {
        return crmOpportunityMilestonePlanDAO.queryPaging(query);
    }

    @Override
    public List<CrmOpportunityMilestonePlanVO> queryListDynamic(CrmOpportunityMilestonePlanQuery query) {
        return crmOpportunityMilestonePlanDAO.queryListDynamic(query);
    }

    @Override
    public CrmOpportunityMilestonePlanVO queryByKey(Long key) {
        CrmOpportunityMilestonePlanDO entity = crmOpportunityMilestonePlanRepo.findById(key).orElseGet(CrmOpportunityMilestonePlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmOpportunityMilestonePlanVO vo = CrmOpportunityMilestonePlanConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOpportunityMilestonePlanVO insert(CrmOpportunityMilestonePlanPayload payload) {
        CrmOpportunityMilestonePlanDO entityDo = CrmOpportunityMilestonePlanConvert.INSTANCE.toDo(payload);
        return CrmOpportunityMilestonePlanConvert.INSTANCE.toVo(crmOpportunityMilestonePlanRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CrmOpportunityMilestonePlanVO update(CrmOpportunityMilestonePlanPayload payload) {
        CrmOpportunityMilestonePlanDO entity = crmOpportunityMilestonePlanRepo.findById(payload.getId()).orElseGet(CrmOpportunityMilestonePlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        CrmOpportunityMilestonePlanDO entityDo = CrmOpportunityMilestonePlanConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmOpportunityMilestonePlanConvert.INSTANCE.toVo(crmOpportunityMilestonePlanRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(CrmOpportunityMilestonePlanPayload payload) {
        CrmOpportunityMilestonePlanDO entity = crmOpportunityMilestonePlanRepo.findById(payload.getId()).orElseGet(CrmOpportunityMilestonePlanDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = crmOpportunityMilestonePlanDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            crmOpportunityMilestonePlanDAO.deleteSoft(keys);
        }
    }

    /**
     * 里程碑计划-发布计划
     */
    @Override
    public void publish(Long id) {
        CrmOpportunityMilestonePlanVO crmOpportunityMilestonePlanVO = crmOpportunityMilestonePlanDAO.queryByKey(id);
        crmOpportunityMilestonePlanVO = (CrmOpportunityMilestonePlanVO) udcUtil.translate(crmOpportunityMilestonePlanVO);
        //商机id
        Long oppoId = crmOpportunityMilestonePlanVO.getOppoId();
        CrmOpportunityVO crmOpportunityVO = crmOpportunityDAO.queryByKey(oppoId);
        Long deliUserId = crmOpportunityVO.getDeliUserId();
        String deliUser = cacheUtil.getUserName(deliUserId);
        if (deliUserId == null) {
            throw TwException.error("", "请先在基本信息中选择交付负责人");
        } else {
            try {
                // 发送邮件给商机的交付负责人
                String noticeSource = deliUserId.toString();
                Map<String, Object> data = new HashMap<>();
                data.put("deliUser", deliUser);
                data.put("oppoName", crmOpportunityVO.getProjectName());
                data.put("milestone", crmOpportunityMilestonePlanVO.getMilestoneDesc());
                // 创建一个自定义的 DateTimeFormatter，指定日期格式和本地化
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("M月d日", Locale.CHINA);
                data.put("dateFrom", crmOpportunityMilestonePlanVO.getDateFrom().format(formatter));
                data.put("dateTo", crmOpportunityMilestonePlanVO.getDateTo().format(formatter));
                PrdMessageConfigVO configVO = messageConfigService.queryByMessageCode("MC20231101001501");
                messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
                log.info("邮件发送成功");
            } catch (Exception e) {
                log.info("邮件发送出现异常");
                log.error(e.getMessage(), e);
            }
        }
    }

}
