package com.elitesland.tw.tw5.server.prd.crm.visit.service;

import cn.hutool.core.lang.Validator;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.coord.messenger.sender.provider.param.TemplateSmsDTO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerForVisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRefService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdFsmFileRefQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdFsmFileRefService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdFsmFileRefVO;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitTaskOpenPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitTaskPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitTaskService;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.*;
import com.elitesland.tw.tw5.server.prd.crm.visit.convert.VisitTaskConvert;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitSignRecordDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitTaskDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitSignRecordDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitTaskDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.repo.VisitTaskRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BusinessPartnerConvert;
import com.elitesland.tw.tw5.server.prd.sms.config.TwSmsProperties;
import com.elitesland.tw.tw5.server.prd.sms.service.TwSmsService;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdFsmRefObjTypeEnum;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 销售拜访任务管理
 *
 * @author duwh
 * @date 2023-03-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class VisitTaskServiceImpl extends BaseServiceImpl implements VisitTaskService {

    private final VisitTaskRepo visitTaskRepo;
    private final VisitTaskDAO visitTaskDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final VisitPlanDAO visitPlanDAO;
    private final VisitPlanDetailDAO visitPlanDetailDAO;
    private final VisitSignRecordDAO visitSignRecordDAO;
    private final FileUtil fileUtil;
    private final TwSmsService twSmsService;
    private final TwSmsProperties twSmsProperties;
    @Resource
    private BusinessPartnerService businessPartnerService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;
    private final PrdFsmFileRefService prdFsmFileRefService;
    private final ShortUrlRefService shortUrlRefService;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    @Value("${tw5.showSignInFlag:false}")
    private  Boolean showSignInFlag;
    @Override
    public PagingVO<VisitTaskVO> paging(VisitTaskQuery query) {
        Page<VisitTaskDO> page = visitTaskRepo.findAll((root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest());
        return PageUtil.toPageVo(page.map(VisitTaskConvert.INSTANCE::toVo));
    }

    @Override
    public PagingVO<VisitTaskVO> queryPaging(VisitTaskQuery query) {
        // 数据权限处理
        dataPermissionFlag(query);
        // 常规计划的任务按拜访时间归在具体日期下
        final PagingVO<VisitTaskVO> pagingVO = visitTaskDAO.queryPaging(query);
        pagingVO.getRecords().forEach(visitTaskVO -> {
            translation(visitTaskVO, false);
        });
        return pagingVO;
    }

    @Override
    public PagingVO<VisitTaskVO> myQueryPaging(VisitTaskQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        // 数据权限处理
//        query.setPermissionFlag(false);
//        query.setCreateUserIdPro(loginUserId);
        query.setVisitMemberId(loginUserId);
        // 常规计划的任务按拜访时间归在具体日期下
        final PagingVO<VisitTaskVO> pagingVO = visitTaskDAO.queryPaging(query);
        pagingVO.getRecords().forEach(visitTaskVO -> {
            translation(visitTaskVO, false);
        });
        return pagingVO;
    }

    /**
     * 权限处理
     *
     * @param query
     */
    private void dataPermissionFlag(VisitTaskQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(),RoleEnum.OPS.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.SALE_VISIT_PIC.getCode(), RoleEnum.SALE_ADMIN.getCode(), RoleEnum.EVAL_TASK_PIC.getCode()));
        query.setPermissionFlag(!rolePermission);
        if (!rolePermission) {
            query.setLoginUserId(userId);
        }

    }

    @Override
    public List<VisitTaskVO> queryListDynamic(VisitTaskQuery query) {
        // 数据权限处理
        dataPermissionFlag(query);
        return visitTaskDAO.queryListDynamic(query);
    }

    @Override
    public List<VisitTaskVO> queryListDynamicWithoutPermission(VisitTaskQuery query) {
        return visitTaskDAO.queryListDynamic(query);
    }

    @Override
    public VisitTaskVO queryByKey(Long key) {
        VisitTaskDO entity = visitTaskRepo.findById(key).orElseGet(VisitTaskDO::new);
        Assert.notNull(entity.getId(), "不存在");
        VisitTaskVO vo = VisitTaskConvert.INSTANCE.toVo(entity);
        // 翻译
        translation(vo, true);
        return vo;
    }

    /**
     * 翻译
     *
     * @param vo                  实体类
     * @param translationFileFlag 翻译附件标志
     */
    private void translation(VisitTaskVO vo, boolean translationFileFlag) {
        vo.setShowSignInFlag(showSignInFlag);
        if(vo.getCreateUserId()!=null){
            vo.setCreateUserName(cacheUtil.getUserName(vo.getCreateUserId()));
        }
        final String teamMemberIds = vo.getTeamMemberIds();
        if (StringUtils.hasText(teamMemberIds)) {
            final String[] teamMemberIdArr = teamMemberIds.split(",");
            List<String> teamMemberNameList = new ArrayList<>();
            for (int i = 0; i < teamMemberIdArr.length; i++) {
                final String userName = cacheUtil.getUserName(Long.valueOf(teamMemberIdArr[i]));
                teamMemberNameList.add(userName);
            }
            final String teamMemberNames = teamMemberNameList.stream().collect(Collectors.joining(","));
            vo.setTeamMemberNames(teamMemberNames);
        }

        final PrdOrgDataRefVO defaultOrgInfo = cacheUtil.getDefaultOrgInfoByUserId(vo.getVisitMemberId());
        // 拜访成员上级
        vo.setVisitMemberParentIdPro(defaultOrgInfo != null ? defaultOrgInfo.getParentId() : null);

        if (translationFileFlag) {
            PrdFsmFileRefQuery prdFsmFileRefQuery = new PrdFsmFileRefQuery();
            prdFsmFileRefQuery.setObjId(vo.getId());
            prdFsmFileRefQuery.setObjType(PrdFsmRefObjTypeEnum.VISIT_TASK_RECORDING.getCode());
            List<PrdFsmFileRefVO> prdFsmFileRefVOS = prdFsmFileRefService.queryList(prdFsmFileRefQuery);
            List<FileObjRespVO> fileObjRespVOList = new ArrayList<>();
            prdFsmFileRefVOS.stream().forEach(prdFsmFileRefVO -> {
                List<FileObjRespVO> fileData = (List<FileObjRespVO>) prdFsmFileRefVO.getFileData();
                if (!CollectionUtils.isEmpty(fileData)) {
                    fileData.forEach(fileObjRespVO -> {
                        if (StringUtils.hasText(prdFsmFileRefVO.getFileName())) {
                            fileObjRespVO.setOriginalName(prdFsmFileRefVO.getFileName());
                        }
                    });
                    fileObjRespVOList.addAll(fileData);
                }
            });
            vo.setFileDatas(fileObjRespVOList);
            vo.setSignFileDatas(fileUtil.getFileDatas(vo.getSignFileCodes()));
            vo.setSignOutFileDatas(fileUtil.getFileDatas(vo.getSignOutFileCodes()));

            // 客户信息
//            final Long customerId = vo.getCustomerId();
//            if (null == customerId) {
//                log.warn("销售拜访计划未关联客户；销售拜访计划：{}", vo);
//                return;
//            }
//            final CrmCustomerSimpleVO simpleVO = customerService.querySimpleByKey(customerId);
//            if (null != simpleVO) {
//                //TODO 客户重构
//                final Long bookId = simpleVO.getBookId();
//                vo.setBookId(bookId);
//                vo.setCompanyAddress(simpleVO.getCompanyAddress());
//                vo.setLongitudeLatitude(simpleVO.getLongitudeLatitude());
//
//                if (null == bookId) {
//                    log.warn("客户数据异常；找不到bookId;  customId:{}", customerId);
//                    return;
//                }
//                // 联系人信息
//                PrdAbContactsQuery prdAbContactsQuery = new PrdAbContactsQuery();
//                prdAbContactsQuery.setBookId(bookId);
//                final PagingVO<PrdAbContactsVO> paging = prdAbContactsService.paging(prdAbContactsQuery);
//                if (paging.isNotEmpty()) {
//                    final PrdAbContactsVO prdAbContactsVO = paging.getRecords().get(0);
//                    vo.setContactsName(prdAbContactsVO.getContactsName());
//                    vo.setContactsPhone(prdAbContactsVO.getContactsPhone());
//                }
//            }

            if (null == vo.getPartnerId()) {
                log.warn("销售拜访计划未关联客户；销售拜访计划：{}", vo);
                return;
            }
            final BusinessPartnerVO simpleVO = businessPartnerService.queryByKeySimple(vo.getPartnerId());
            if (null != simpleVO) {
                final Long bookId = simpleVO.getBookId();
                if (null == bookId) {
                    log.warn("客户数据异常；找不到bookId;  partnerId:{}", vo.getPartnerId());
                    return;
                }
                BookAddressVO bookAddressVO = bookAddressService.queryDefaultByBookId(bookId);
                if (bookAddressVO != null) {
                    vo.setBookId(bookId);
                    vo.setCompanyAddress(bookAddressVO.getDetailAddress());
                    vo.setLongitudeLatitude(bookAddressVO.getLongitudeLatitude());
                }
                // 联系人信息
                BookContactsVO bookContactsVO = bookContactsService.queryDefaultByBookId(bookId);
                if (null != bookContactsVO) {
                    vo.setContactsName(bookContactsVO.getContactsName());
                    vo.setContactsPhone(bookContactsVO.getContactsPhone());
                }
                // 客户阶段
                BusinessCustomerInfoVO businessCustomerInfoVO = businessCustomerInfoService.queryByPartnerId(vo.getPartnerId());
                if(null != businessCustomerInfoVO){
                    vo.setCustomerStage(businessCustomerInfoVO.getCustomerStage());
                }
            }

        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public VisitTaskVO insert(VisitTaskPayload payload) {
        // 检查
        check(payload);
        // 数据处理
        dataProcess(payload);

        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        final VisitTaskDO save = visitTaskRepo.save(entityDo);

        // 处理签到信息历史记录
        signDataProcess(payload, save);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public VisitTaskVO update(VisitTaskPayload payload) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (ObjectUtils.isEmpty(payload.getId())) {
            throw TwException.error("", "id不能为空");
        }
        VisitTaskDO entity = visitTaskRepo.findById(payload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull(entity.getId(), "拜访任务不存在");

        // 校验
        checkUpdate(payload, entity);

        if (ObjectUtils.isEmpty(payload.getPlanId())) {
            payload.setPlanId(entity.getPlanId());
        }
        dataProcess(payload);

        if (!ObjectUtils.isEmpty(payload.getStatus()) && payload.getStatus().equals(VisitTaskStatusEnum.OK.getCode())) {
            // 校验操作权限
            //拜访成员可执行、提交、保存任务；
            if (!(loginUserId.equals(entity.getVisitMemberId()) || rolePermission)) {
                throw TwException.error("", "权限不足");
            }

            payload.setSubmitTime(LocalDateTime.now());
            payload.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
            Long partnerId = entity.getPartnerId();
            // 判断销售拜访计划 类型为 常规、周期；
            if (payload.getPlanType() != null) {
                if (payload.getPlanType().equals(VisitTaskPlanTypeEnum.general_plan.getCode()) || payload.getPlanType().equals(VisitTaskPlanTypeEnum.periodic_plan.getCode())) {
                    // 给客户发送反馈评价 partnerId 来自数据库
                    boolean sendSmsFlag = sendSms(entity.getId(), entity.getSendFlag(), partnerId);
                    if (sendSmsFlag) {
                        entity.setSendFlag(1);
                    }
                }
                if (payload.getPlanType().equals(VisitTaskPlanTypeEnum.sell_visit_plan.getCode())) {
                    // partnerId 来自关系 给客户发送反馈评价
                    boolean sendSmsFlag = sendSms(entity.getId(), entity.getSendFlag(), payload.getPartnerId());
                    if (sendSmsFlag) {
                        entity.setSendFlag(1);
                    }
                }
            }
        }

        if (StringUtils.hasText(payload.getCustomerDesc())
                || StringUtils.hasText(payload.getResult())
                || null != payload.getNextVisitTime()
                || StringUtils.hasText(payload.getSignLocations())
                || StringUtils.hasText(payload.getSignOutLocations())
        ) {
            // 校验操作权限
            //拜访成员可执行、提交、保存任务；
            if (!(loginUserId.equals(entity.getVisitMemberId()) || rolePermission)) {
                throw TwException.error("", "权限不足");
            }
            if (ObjectUtils.isEmpty(payload.getStatus())) {
                payload.setStatus(VisitTaskStatusEnum.READY.getCode());
            }
        }

        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);

        final VisitTaskDO save = visitTaskRepo.save(entity);
        final Long planId = save.getPlanId();

        // 处理签到信息历史记录
        signDataProcess(payload, save);

        // 校验任务状态  某个计划下所有任务都提交后，计划状态修改为已完成
        // 更新拜访计划状态
        if (planId != null) {
            updatePlanStatus(planId);
        }
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean sendSms(Long taskId, Integer sendFlag, Long partnerId) {
        // 根据业务伙伴主键 查询默认联系人 电话
        if (null != partnerId) {
            final BusinessPartnerVO simpleVO = businessPartnerService.queryByKeySimple(partnerId);
            if (null != simpleVO) {
                final Long bookId = simpleVO.getBookId();
                if (null == bookId) {
                    log.warn("客户数据异常；找不到bookId;  partnerId:{}", partnerId);
                    return false;
                }
                // 联系人信息
                BookContactsVO bookContactsVO = bookContactsService.queryDefaultByBookId(bookId);
                if (null != bookContactsVO) {
                    String contactsPhone = bookContactsVO.getContactsPhone();
                    String contactsName = bookContactsVO.getContactsName();
                    if (!StringUtils.hasText(contactsName)) {
                        contactsName = "客户";
                    }
                    // 先校验是否发过短信
                    if (sendFlag == null || (sendFlag != null && sendFlag == 0)) {
                        TemplateSmsDTO smsDTO = new TemplateSmsDTO();

                        Set<String> mobile = new HashSet<>();
                        mobile.add(contactsPhone);

//                        smsDTO.setTemplateCode("SMS_114300083");
                        String smsTemplateCode = twSmsProperties.getSmsTemplateCodeVisitTaskEval();
                        smsDTO.setTemplateCode(smsTemplateCode);
                        smsDTO.setSignName("埃林哲CRM");
                        smsDTO.setMobiles(mobile);

                        smsDTO.setSubject("Elitesland");
                        smsDTO.setBusinessType("CRM-TESTSEND");

                        // 根据客户id 查询 手机号 和名称;
                        //取出手机号后校验
                        boolean isMobile = Validator.isMobile(contactsPhone);
                        if (isMobile) {
                            // 评价地址改为h5项目的地址
                            ShortUrlRefVO shortUrlRefVO = shortUrlRefService.saveRedirect(twSmsProperties.getVisitTaskEvalRedirectUri() + "?taskId=" + taskId);
                            String code = shortUrlRefVO.getCode();
                            String shortUrlRelative = shortUrlRefVO.getShortUrlRelative();
                            if (!StringUtils.hasText(shortUrlRelative)) {
                                shortUrlRelative = "/tw-server5-crm/s/r/";
                            }
                            String jumpuri = shortUrlRelative + code;

                            Map<String, String> map = new HashMap<>();
                            map.put("name", contactsName);
                            map.put("jumpuri", jumpuri);
                            map.put("templateCode", smsTemplateCode);
                            smsDTO.setTemplateParams(map);
                            //发送短信
                            ApiResult<Boolean> booleanApiResult = twSmsService.sendTemplateMsg(smsDTO);
                            if (booleanApiResult.isSuccess()) {
                                // 发送成功以后，标记此任务 sendFlag=1
//                                long updateCount = visitTaskDAO.updateSendFlag(taskId);
//                                return updateCount > 0;
                                return true;
                            } else {
                                log.error("发送客户评价异常：", booleanApiResult.getErrorMsg());
                            }

                        } else {
                            log.error("销售拜访任务相关客户【{}】,的联系人手机号配置错误：【{}】", "test", mobile);
                        }

                    }
                } else {
                    log.error("发送客户评价异常：", "未匹配到客户联系人信息");
                }
            }
        }
        return false;
    }


    /**
     * 处理签到信息历史记录
     *
     * @param payload 有效载荷
     * @param save    保存
     */
    private void signDataProcess(VisitTaskPayload payload, VisitTaskDO save) {
        final LocalDateTime now = LocalDateTime.now();
        if (!ObjectUtils.isEmpty(payload.getSignLocations())) {
            VisitSignRecordDO signRecordDO = new VisitSignRecordDO();
            signRecordDO.setTaskId(save.getId());
            signRecordDO.setPlanId(save.getPlanId());
            signRecordDO.setType(VisitSignTypeEnum.IN.getCode());
            signRecordDO.setTaskName(save.getTaskName());
            signRecordDO.setFileCodes(payload.getSignFileCodes());
            signRecordDO.setSignTime(now);
            signRecordDO.setLocations(payload.getSignLocations());
            signRecordDO.setAddress(payload.getSignAddress());
            visitSignRecordDAO.save(signRecordDO);
        }
        if (!ObjectUtils.isEmpty(payload.getSignOutLocations())) {
            VisitSignRecordDO signRecordDO = new VisitSignRecordDO();
            signRecordDO.setTaskId(save.getId());
            signRecordDO.setPlanId(save.getPlanId());
            signRecordDO.setType(VisitSignTypeEnum.OUT.getCode());
            signRecordDO.setTaskName(save.getTaskName());
            signRecordDO.setFileCodes(payload.getSignOutFileCodes());
            signRecordDO.setSignTime(now);
            signRecordDO.setLocations(payload.getSignOutLocations());
            signRecordDO.setAddress(payload.getSignOutAddress());
            visitSignRecordDAO.save(signRecordDO);
        }
    }

    /**
     * 根据拜访计划生成任务
     *
     * @param planId 计划id
     * @return {@link List}<{@link VisitTaskVO}>
     */
    @Override
    public List<VisitTaskVO> generateTaskByPlanId(Long planId) {
        List<VisitTaskDO> taskDOList = new ArrayList<>();
        if (null != planId) {
            final VisitPlanVO visitPlanVO = visitPlanDAO.queryByKey(planId);
            Assert.notNull(visitPlanVO, "拜访计划不存在");
            // 计划类型
            final String visitPlanType = visitPlanVO.getVisitPlanType();
            int visitTimesInt = 1;
            // 常规计划 只生成一次任务  其他类型判断 次数
            if (!VisitTaskPlanTypeEnum.general_plan.getCode().equals(visitPlanType)) {
                final String visitTimes = visitPlanVO.getVisitTimes();
                if (ObjectUtils.isEmpty(visitTimes)) {
                    throw TwException.error("", "拜访次数不能为空");
                }
                visitTimesInt = Integer.valueOf(visitTimes);
            }
//            final Long customId = visitPlanVO.getCustomId();
//            String customerName = "";
//            if (!ObjectUtils.isEmpty(customId)) {
//                // 查询客户名称
//                final CrmCustomerVO crmCustomerVO = crmCustomerDAO.queryDetail(customId);
//                Assert.notNull(crmCustomerVO, "客户不存在");
//                customerName = crmCustomerVO.getCustomerName();
//            }

            final Long partnerId = visitPlanVO.getPartnerId();
            String customerName = "";
            if (!ObjectUtils.isEmpty(partnerId)) {
                // 查询客户名称
                BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(partnerId);
                Assert.notNull(businessPartnerVO, "客户不存在");
                customerName = businessPartnerVO.getPartnerName();
            }
            // 先清空 ，再插入
            deleteSoftByPlanId(planId);

            VisitPlanDetailQuery planDetailQuery = new VisitPlanDetailQuery();
            planDetailQuery.setVisitPlanId(planId);
            List<VisitPlanDetailVO> planDetailVOList = visitPlanDetailDAO.queryListDynamic(planDetailQuery);

            if (!CollectionUtils.isEmpty(planDetailVOList)) {
                // 查出协访人员
                //final String teamMemberIds = planDetailVOList.stream()
                //    .filter(visitPlanDetailVO -> visitPlanDetailVO.getVisitPersonType().equals(VisitTaskPlanPersonType.accompany_person.getCode()))
                //    .distinct()
                //    .map(visitPlanDetailVO -> visitPlanDetailVO.getVisitPersonId() + "")
                //    .collect(Collectors.joining(","));

                // 只取拜访成员
                planDetailVOList = planDetailVOList.stream()
                        .filter(visitPlanDetailVO -> visitPlanDetailVO.getVisitPersonType().equals(VisitTaskPlanPersonTypeEnum.visit_person.getCode()))
                        .distinct()
                        .collect(Collectors.toList());
                int i = 1;
                // 根据计划类型 判断生成任务数据  计划名称-拜访成员-任务编号
                for (VisitPlanDetailVO planDetailVO : planDetailVOList) {
                    // 拜访次数
                    for (int j = 0; j < visitTimesInt; j++) {
                        VisitTaskDO taskDO = new VisitTaskDO();
                        final String visitPlanName = visitPlanVO.getVisitPlanName();
                        taskDO.setPlanId(planId);
                        taskDO.setPlanName(visitPlanName);
                        taskDO.setPlanType(visitPlanType);
                        taskDO.setObjId(visitPlanVO.getObjId());
                        taskDO.setObjName(visitPlanVO.getObjName());
                        taskDO.setObjType(visitPlanVO.getObjType());
                        taskDO.setStartTime(visitPlanVO.getVisitDateFrom());
                        taskDO.setEndTime(visitPlanVO.getVisitDateTo());
                        taskDO.setPlanCreateUserId(visitPlanVO.getCreateUserId());
                        taskDO.setStatus(VisitTaskStatusEnum.NEW.getCode());
//                        taskDO.setCustomerId(customId);
                        taskDO.setPartnerId(partnerId);
                        taskDO.setCustomerName(customerName);

                        taskDO.setTeamMemberIds(visitPlanVO.getExtString2());

                        final Long visitPersonId = planDetailVO.getVisitPersonId();
                        taskDO.setVisitMemberId(visitPersonId);
                        final String userName = cacheUtil.getUserName(visitPersonId);
                        taskDO.setVisitMemberName(userName);

                        final PrdOrgDataRefVO defaultOrgInfo = cacheUtil.getDefaultOrgInfoByUserId(visitPersonId);
                        // 直属上级
                        taskDO.setVisitMemberParentId(defaultOrgInfo != null ? defaultOrgInfo.getParentId() : null);

                        // 计划名称-拜访成员-任务编号
                        taskDO.setTaskName(visitPlanName + "-" + userName + "-" + i);

                        // 访销计划就是访销任务
                        if ("sell_visit_plan".equals(visitPlanVO.getVisitPlanType())) {
                            taskDO.setTaskType("sell_visit_task");
                        } else if ("periodic_plan".equals(visitPlanVO.getVisitPlanType())) {
                            taskDO.setTaskType("periodic_task");
                        } else if ("general_plan".equals(visitPlanVO.getVisitPlanType())) {
                            taskDO.setTaskType("general_task");
                        }
                        i++;

                        taskDOList.add(taskDO);
                    }
                }
            }

        }
        if (!CollectionUtils.isEmpty(taskDOList)) {
            visitTaskDAO.saveAll(taskDOList);
        }
        return VisitTaskConvert.INSTANCE.toVoList(taskDOList);
    }

    /**
     * 更新拜访计划状态
     *
     * @param planId 计划id
     */
    private void updatePlanStatus(Long planId) {
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setPlanId(planId);
        visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        final long count = visitTaskDAO.count(visitTaskQuery);

        VisitTaskQuery visitTaskQueryAll = new VisitTaskQuery();
        visitTaskQueryAll.setPlanId(planId);
        final long countAll = visitTaskDAO.count(visitTaskQueryAll);

        if (count == countAll) {
            // 更新计划状态
            visitPlanDAO.completeVisitPlan(planId);
        }
    }

    /**
     * 数据处理
     *
     * @param payload 有效载荷
     */
    private void dataProcess(VisitTaskPayload payload) {
        Long partnerId = payload.getPartnerId();
        if (payload.getPlanId() != null) {
            final VisitPlanVO visitPlanVO = visitPlanDAO.queryByKey(payload.getPlanId());
            Assert.notNull(visitPlanVO, "拜访计划不存在");
            payload.setPlanName(visitPlanVO.getVisitPlanName());
            payload.setPlanType(visitPlanVO.getVisitPlanType());

            // 拜访任务 相对独立了 不再完全依赖拜访计划
            payload.setObjId(null != payload.getObjId() ? payload.getObjId() : visitPlanVO.getObjId());
            payload.setObjName(StringUtils.hasText(payload.getObjName()) ? payload.getObjName() : visitPlanVO.getObjName());
            payload.setObjType(StringUtils.hasText(payload.getObjType()) ? payload.getObjType() : visitPlanVO.getObjType());
            payload.setStartTime(null != payload.getStartTime() ? payload.getStartTime() : visitPlanVO.getVisitDateFrom());
            payload.setEndTime(null != payload.getEndTime() ? payload.getEndTime() : visitPlanVO.getVisitDateTo());

            // 客户地址
            payload.setCustomAdress(StringUtils.hasText(payload.getCustomAdress()) ? payload.getCustomAdress() : visitPlanVO.getCustomAdress());
            // 客户经纬度
            payload.setLongitudeLatitude(StringUtils.hasText(payload.getLongitudeLatitude()) ? payload.getLongitudeLatitude() : visitPlanVO.getLongitudeLatitude());

            payload.setPlanCreateUserId(visitPlanVO.getCreateUserId());
            if (ObjectUtils.isEmpty(partnerId)) {
                partnerId = visitPlanVO.getPartnerId();
            }
        }
        if (ObjectUtils.isEmpty(partnerId)) {
            payload.setPartnerId(partnerId);
        }

        // 访销计划 计划里没有客户信息 拜访任务里维护客户信息
//        Long customId = payload.getCustomerId();
//        if (ObjectUtils.isEmpty(customId)) {
//            customId = visitPlanVO.getCustomId();
//            payload.setCustomerId(customId);
//        }
//        if (!ObjectUtils.isEmpty(customId)) {
//            // 查询客户名称
//            final CrmCustomerVO crmCustomerVO = crmCustomerDAO.queryDetail(customId);
//            Assert.notNull(crmCustomerVO, "客户不存在");
//            payload.setCustomerName(crmCustomerVO.getCustomerName());
//        }

        if (!ObjectUtils.isEmpty(partnerId)) {
            // 查询客户名称
            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(partnerId);
            Assert.notNull(businessPartnerVO, "客户不存在");
            payload.setCustomerName(businessPartnerVO.getPartnerName());
        }


        // 新建状态
        if (ObjectUtils.isEmpty(payload.getStatus()) && null == payload.getId()) {
            payload.setStatus(VisitTaskStatusEnum.NEW.getCode());
        }
        if (!ObjectUtils.isEmpty(payload.getSignLocations())) {
            if (null == payload.getSignTime()) {
                payload.setSignTime(LocalDateTime.now());
            }
        }
        if (!ObjectUtils.isEmpty(payload.getSignOutLocations())) {
            if (null == payload.getSignOutTime()) {
                payload.setSignOutTime(LocalDateTime.now());
            }
        }
    }

    /**
     * 检查
     *
     * @param payload 有效载荷
     */
    private void check(VisitTaskPayload payload) {
        if (ObjectUtils.isEmpty(payload.getPlanId())) {
            throw TwException.error("", "planId不能为空");
        }
        // todo wangly 情况太多 不止这里 后期优化
//        if(StringUtils.hasText(payload.getTeamMemberIds())&&payload.getVisitMemberId()!=null){
//            if(payload.getTeamMemberIds().contains(payload.getVisitMemberId().toString())){
//                throw TwException.error("","协防人员不能包含拜访人员");
//            }
//        }
    }

    /**
     * 检查更新
     *
     * @param payload 有效载荷
     * @param entity  实体
     */
    private void checkUpdate(VisitTaskPayload payload, VisitTaskDO entity) {
        // 已提交的任务不可变更
        if (entity.getStatus().equals(VisitTaskStatusEnum.OK.getCode())) {
            throw TwException.error("", "已提交的任务不可变更");
        }
        // 未开始/待提交的任务可变更执行信息-客户情况说明、拜访进展与结果、下次拜访时间

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        final Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional<VisitTaskDO> optional = visitTaskRepo.findById(id);
                if (!optional.isEmpty()) {
                    VisitTaskDO entity = optional.get();
                    //计划创建人、拜访成员可删除任务，拜访成员可执行、提交、保存任务；
                    if ((null != entity.getPlanCreateUserId() && entity.getPlanCreateUserId().equals(loginUserId)) || entity.getVisitMemberId().equals(loginUserId) || rolePermission) {
                        // 校验状态
                        if (!entity.getStatus().equals(VisitTaskStatusEnum.NEW.getCode())) {
                            throw TwException.error("", "[" + entity.getTaskName() + "]当前状态不允许删除");
                        }

                    } else {
                        throw TwException.error("", "[" + entity.getTaskName() + "]无权限删除");
                    }
                }
            });
            visitTaskDAO.deleteSoft(keys);
        }
    }

    /**
     * 根据计划删除软id
     *
     * @param planId 计划id
     */
    @Override
    public void deleteSoftByPlanId(Long planId) {
        if (null != planId) {
            final long count = countByPlanId(planId);
            if (count > 0) {
                throw TwException.error("", "任务状态不允许删除");
            }
            visitTaskDAO.deleteSoftByPlanId(planId);
        }
    }

    /**
     * 统计任务数量 ：拜访计划下 任务状态为【已完成、待提交】的数据
     *
     * @param planId 计划id
     * @return long
     */
    @Override
    public long countByPlanId(Long planId) {
        VisitTaskQuery taskQuery = new VisitTaskQuery();
        taskQuery.setPlanId(planId);
        List<String> statusList = new ArrayList<>();
        statusList.add(VisitTaskStatusEnum.OK.getCode());
        statusList.add(VisitTaskStatusEnum.READY.getCode());
        taskQuery.setStatusList(statusList);
        return visitTaskDAO.count(taskQuery);
    }

    /**
     * 客户评价
     *
     * @param openPayload 开放有效载荷
     * @return {@link VisitTaskOpenPayload}
     */
    @Override
    public VisitTaskOpenPayload customerEval(VisitTaskOpenPayload openPayload) {
        VisitTaskDO entity = visitTaskRepo.findById(openPayload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull(entity.getId(), "拜访不存在");

        VisitTaskPayload payload = new VisitTaskPayload();
        payload.setId(openPayload.getId());
        payload.setCustomerGradle(openPayload.getCustomerGradle());
        payload.setCustomerAdvise(openPayload.getCustomerAdvise());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        visitTaskRepo.save(entity);
        return openPayload;
    }

    /**
     * 领导评价
     *
     * @param payload 有效载荷
     * @return {@link VisitTaskVO}
     */
    @Override
    public VisitTaskVO leaderEval(VisitTaskPayload payload) {
        VisitTaskDO entity = visitTaskRepo.findById(payload.getId()).orElseGet(VisitTaskDO::new);
        Assert.notNull(entity.getId(), "拜访不存在");
        VisitTaskPayload update = new VisitTaskPayload();
        update.setId(payload.getId());
        update.setLeaderGradle(payload.getLeaderGradle());
        update.setEvalStatus(VisitTaskEvalStatusEnum.OK.getCode());
        update.setNextPlan(payload.getNextPlan());
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(update);
        entity.copy(entityDo);
        final VisitTaskDO save = visitTaskRepo.save(entity);
        return VisitTaskConvert.INSTANCE.toVo(save);
    }

    /**
     * 统计
     *
     * @param query 查询
     * @return long
     */
    @Override
    public long count(VisitTaskQuery query) {
        return visitTaskDAO.count(query);
    }

    /**
     * 业务伙伴管理-新增
     *
     * @param payload 有效载荷
     * @return {@link BusinessPartnerVO}
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessPartnerVO businessPartnerInsert(BusinessPartnerForVisitTaskPayload payload) {
        // 销售拜访任务 客户 关系绑定  and  拜访任务状态提交
        final Long visitTaskId = payload.getVisitTaskId();
        if (ObjectUtils.isEmpty(visitTaskId)) {
            throw TwException.error("", "visitTaskId不能为空");
        }
        VisitTaskDO entity = visitTaskRepo.findById(visitTaskId).orElseGet(VisitTaskDO::new);
        Assert.notNull(entity.getId(), "拜访任务不存在");

        BusinessPartnerPayload businessPartnerPayload = BusinessPartnerConvert.INSTANCE.taskPayLoadToPayLoad(payload);
        BusinessPartnerVO insert = businessPartnerService.insert(businessPartnerPayload);
        VisitTaskPayload visitTaskPayload = new VisitTaskPayload();
        visitTaskPayload.setId(visitTaskId);
        visitTaskPayload.setStatus(VisitTaskStatusEnum.OK.getCode());
        visitTaskPayload.setPartnerId(insert.getId());

        visitTaskPayload.setSubmitTime(LocalDateTime.now());
        visitTaskPayload.setEvalStatus(VisitTaskEvalStatusEnum.NEW.getCode());
        visitTaskPayload.setCustomerName(insert.getPartnerName());
        visitTaskPayload.setCustomAdress(insert.getDetailAddress());

        visitTaskPayload.setLongitudeLatitude(insert.getLongitudeLatitude());

        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(visitTaskPayload);
        entity.copy(entityDo);
        visitTaskRepo.save(entity);
//        update(visitTaskPayload);
        return insert;
    }

    @Override
    public VisitTaskVO insertTask(VisitTaskPayload payload) {
        LocalDate currentDate = LocalDate.now();    // 当前日期
        Long loginUserId = GlobalUtil.getLoginUserId(); //当前登录用户
        Long partnerId = payload.getPartnerId();
        String taskName = "";
        if (!ObjectUtils.isEmpty(partnerId)) {
            // 查询客户名称
            BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(partnerId);
            Assert.notNull(businessPartnerVO, "客户不存在");
            payload.setCustomerName(businessPartnerVO.getPartnerName());
        }
        if (payload.getCustomerName() == null) {
            taskName = currentDate + "-" + GlobalUtil.getLoginUserName();
        } else {
            taskName = currentDate + "-" + payload.getCustomerName() + "-" + GlobalUtil.getLoginUserName(); // 任务名称  当日日期-拜访客户名称-拜访成员
        }
        payload.setStartTime(currentDate);  //拜访时间开始
        payload.setEndTime(currentDate);  //拜访时间结束
        payload.setTaskName(taskName);  //任务名称
        payload.setVisitMemberId(loginUserId);  //拜访用户id
        payload.setVisitMemberName(GlobalUtil.getLoginUserName());  //拜访用户名称
        payload.setStatus(VisitTaskEvalStatusEnum.NEW.getCode());   // 任务状态
        VisitTaskDO entityDo = VisitTaskConvert.INSTANCE.toDo(payload);
        return VisitTaskConvert.INSTANCE.toVo(visitTaskRepo.save(entityDo));
    }
}
